<?php

namespace App\Data\Woo;

use App\Data\BaseData;

class AttributeData extends BaseData
{
    public function __construct(
        public readonly ?int $id,
        public readonly ?string $name,
        public readonly ?bool $visible,
        public readonly ?bool $variation,
        /** @var string[]|null */
        public readonly ?array $options,
    ) {}

    protected static function casts(): array
    {
        return [
            'id'       => 'int',
            'name'     => 'string',
            'visible'  => 'bool',
            'variation'=> 'bool',
            'options'  => 'array',
        ];
    }
}
