<?php

namespace App\Data\Woo;

use App\Data\BaseData;

class OrderAddressData extends BaseData
{
    public function __construct(
        public readonly ?string $firstName,
        public readonly ?string $lastName,
        public readonly ?string $company,
        public readonly ?string $address1,
        public readonly ?string $address2,
        public readonly ?string $city,
        public readonly ?string $state,
        public readonly ?string $postcode,
        public readonly ?string $country,
        public readonly ?string $email,  // present on billing
        public readonly ?string $phone,  // present on billing
    ) {}

    protected static function casts(): array
    {
        return [
            'firstName' => 'string',
            'lastName' => 'string',
            'company' => 'string',
            'address1'  => 'string',
            'address2' => 'string',
            'city'    => 'string',
            'state'     => 'string',
            'postcode' => 'string',
            'country' => 'string',
            'email'     => 'string',
            'phone'    => 'string',
        ];
    }
}
