<?php

namespace App\Http\Actions\User;

use App\Events\NewShopAccountCreated;
use App\Http\Requests\StoreShopRequest;
use App\Models\Shop;
use Illuminate\View\View;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class StoreUserShopRequestAction
{
    public function __invoke(StoreShopRequest $request)
    {

        if (Auth::user()->hasShop()) {
            return redirect()->route('user.request.shop.account')->with('error', __('You already have a shop.'));
        }

        $validatedData = $request->validated();

        $logoPath = null;
        if ($request->hasFile('logo') && $request->file('logo')->isValid()) {
            $logoPath = $request->file('logo')->store('shop_logos', 'public_upload');
        }

        $shop = Shop::create([
            'user_id' => Auth::id(),
            'name' => $validatedData['name'],
            'slug' => Str::slug($validatedData['name']), // Or use your HasUniqueSlug trait logic if it handles this automatically
            'logo' => $logoPath,
            'description' => $validatedData['description'],
            'phone' => $validatedData['phone'],
            'email' => $validatedData['email'],
            'address' => $validatedData['address'],
            'city' => $validatedData['city'],
            'state' => $validatedData['state'],
            'postal_code' => $validatedData['postal_code'],
            'country' => $validatedData['country'],
            'is_approved' => false, // Default to not approved
        ]);

        event(new NewShopAccountCreated($shop));

        return redirect()->route('user.request.shop.account')->with('success', __('Shop request submitted successfully. It will be reviewed by an administrator.'));
    }
}
