<?php

namespace App\Http\Controllers\Admin\Delivery;

use App\Http\Controllers\Controller;
use App\Models\Delivery;
use Illuminate\Http\Request;

class DeliveryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $deliveries = Delivery::query()
            ->when($request->status, fn($q, $status) => $q->where('status', $status))
            ->when($request->date, fn($q, $date) => $q->whereDate('created_at', $date))
            ->get();
        return view('pages.admin.deliveries.index', compact('deliveries'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        return view('pages.admin.deliveries.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'provider_id' => 'required|exists:delivery_providers,id',
            'slot_id' => 'required|exists:delivery_times,id',
            'status' => 'required',
            'tracking_code' => 'nullable|string',
        ]);
        $delivery = Delivery::create($validated);
        return redirect()->route('admin.deliveries.index')->with('success', __('Delivery created successfully'));
    }

    /**
     * Display the specified resource.
     */
    public function show(Delivery $delivery)
    {
        return view('pages.admin.deliveries.show', compact('delivery'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request $request, Delivery $delivery)
    {
        return view('pages.admin.deliveries.edit', compact('delivery'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Delivery $delivery)
    {
        $validated = $request->validate([
            'provider_id' => 'required|exists:delivery_providers,id',
            'slot_id' => 'required|exists:delivery_times,id',
            'status' => 'required',
            'tracking_code' => 'nullable|string',
        ]);
        $delivery->update($validated);
        return redirect()->route('admin.deliveries.index')->with('success', __('Delivery updated successfully'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Delivery $delivery)
    {
        $delivery->delete();
        return redirect()->route('admin.deliveries.index')->with('success', __('Delivery deleted successfully'));
    }
}
