<?php

namespace App\Http\Controllers\Admin\Delivery;

use App\Models\DeliveryTime;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DeliveryTimeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $deliveryTimes = DeliveryTime::all();
        return view('pages.admin.delivery.time.index', compact('deliveryTimes'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('pages.admin.delivery.time.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'day' => 'required|max:255',
            'from' => 'required|max:255',
            'until' => 'required|max:255',
            'capacity' => 'required|max:255',
        ]);

        DeliveryTime::create($validated);

        return redirect()->route('admin.delivery.times.index')->sweetalert()->success(__('Delivery time created successfully.'));
    }

    /**
     * Display the specified resource.
     */
    public function show(DeliveryTime $deliveryTime)
    {
        return view('pages.admin.delivery.time.show', compact('deliveryTime'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(DeliveryTime $time)
    {
        return view('pages.admin.delivery.time.edit', compact('time'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, DeliveryTime $time)
    {
        $validated = $request->validate([
            'day' => 'required|max:255',
            'from' => 'required|max:255',
            'until' => 'required|max:255',
            'capacity' => 'required|max:255',
        ]);

        $time->update($validated);

        return redirect()->route('admin.delivery.times.index')->sweetalert()->success(__('Delivery time updated successfully.'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(DeliveryTime $time)
    {
        $time->delete();

        return redirect()->route('admin.delivery.times.index')->sweetalert()->success(__('Delivery time deleted successfully.'));
    }
}
