<?php

namespace App\Http\Controllers\Admin\Settings;

use Illuminate\Http\Request;
use App\Cache\CategoryTreeCache;
use App\Cache\Contracts\Cacheable;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Artisan;

class CacheController extends Controller
{
    protected array $cacheables = [
        'CategoryTreeCache' => CategoryTreeCache::class,
        // Add more here...
    ];

    public function index()
    {
        return view('pages.admin.settings.cache.index', [
            'cacheables' => $this->cacheables
        ]);
    }

    public function resolveCache(string $class): Cacheable
    {
        return app($this->cacheables[$class] ?? throw new \Exception("Cache class not found"));
    }

    public function refresh(Request $request)
    {
        $this->resolveCache($request->cacheable)->refresh();
        return back()->with('status', __('Cache refreshed.'));
    }

    public function clear(Request $request)
    {
        $this->resolveCache($request->cacheable)->clear();
        return back()->with('status', __('Cache cleared.'));
    }

    public function value(Request $request)
    {
        $value = $this->resolveCache($request->cacheable)->get();
        return back()->with('status', __('Cache value fetched.'))->with('value', $value);
    }


    public function clearAllCache()
    {
        Artisan::call('cache:clear');
        Artisan::call('config:clear');
        Artisan::call('route:clear');
        Artisan::call('view:clear');

        return response()->json([
            'status' => 'success',
            'message' => __('All caches cleared successfully.')
        ]);
    }

    /**
     * Cache everything (config, route, view).
     */
    public function cacheEverything()
    {
        Artisan::call('config:cache');
        Artisan::call('route:cache');
        Artisan::call('view:cache');

        return response()->json([
            'status' => 'success',
            'message' => __('All caches generated successfully.')
        ]);
    }
}
