<?php

namespace App\Http\Controllers\Development;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Artisan;

class InstallController extends Controller
{

    public function seed()
    {
        // Define the path to the marker file
        $markerFile = base_path('database_seeded.txt');

        if (!file_exists($markerFile)) {
            try {
                Artisan::call("migrate:fresh --seed");
                // Create the marker file to indicate the database has been seeded
                file_put_contents($markerFile, 'Database seeding completed on ' . date('Y-m-d H:i:s'));

                echo "Database updated successfully";
            } catch (\Throwable $th) {
                dd($th);
            }
        } else {
            echo "Database migration skipped. Marker file exists at: \$markerFile";
        }
    }
}
