<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class FilterController extends Controller
{
    public function shopClear(Request $request)
    {
        $request->session()->forget('shop');
        return back();
    }
    public function shopOrderBy(Request $request)
    {
        if ($request->has('order_by')) {
            $request->session()->put('shop.order_by', $request->input('order_by'));
        }
        return back();
    }

    public function onlyAvailable(Request $request)
    {
        if ($request->has('only_available')) {
            $request->session()->put('shop.only_available', $request->input('only_available'));
        } else {
            $request->session()->forget('shop.only_available');
        }
        return back();
    }
    public function onlySpecialOffer(Request $request)
    {
        if ($request->has('only_special_offer')) {
            $request->session()->put('shop.only_special_offer', $request->input('only_special_offer'));
        } else {
            $request->session()->forget('shop.only_special_offer');
        }
        return back();
    }
    public function onlySecondHand(Request $request)
    {
        if ($request->has('only_second_hand')) {
            $request->session()->put('shop.only_second_hand', $request->input('only_second_hand'));
        } else {
            $request->session()->forget('shop.only_second_hand');
        }
        return back();
    }
    public function onlyConsumable(Request $request)
    {
        if ($request->has('only_consumable')) {
            $request->session()->put('shop.only_consumable', $request->input('only_consumable'));
        } else {
            $request->session()->forget('shop.only_consumable');
        }
        return back();
    }
    public function price(Request $request)
    {
        if ($request->has('min') && $request->has('max')) {
            $request->session()->put('shop.price.min', $request->input('min'));
            $request->session()->put('shop.price.max', $request->input('max'));
        } else {
            $request->session()->forget('shop.price.min');
            $request->session()->forget('shop.price.max');
        }
        return back();
    }
}
