<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CategoryAttributeItem extends Model
{
    protected $fillable = [
        'category_attribute_id',
        'item_group',
        'item_key',
        'item_value',
        'data',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    /**
     * The part below is for this model relationships
     */
    public function attribute(): BelongsTo
    {
        return $this->belongsTo(CategoryAttribute::class, 'product_attribute_id');
    }
    /**
     * The above is for this model relationships
     */
}
