<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Otp extends Model
{
    protected $fillable = [
        'phone',
        'email',
        'code',
        'service',
        'token',
        'identifier',
        'is_verified',
        'expiry_time',
    ];

    public static function latestActiveCodeForPhone($phone)
    {
        return self::where('is_verified', 0)->where('phone', $phone)->where('expiry_time', '>', Carbon::now()->format('Y-m-d H:i:s'))->orderBy('created_at', 'desc')->orderBy('id', 'desc')->first();
    }

    public static function lastHourActiveCodeForPhone($phone)
    {
        return self::where('is_verified', 0)->where('phone', $phone)->where('created_at', '>', Carbon::now()->subHour())->orderBy('created_at', 'desc')->orderBy('id', 'desc')->get();
    }

    public static function activeCode()
    {
        return self::where('is_verified', 0)->where('expiry_time', '>', now())->get();
    }

    public static function boot()
    {
        parent::boot();

        self::creating(function ($model) {

            $codes = $model->activeCode();
            do {
                $code = rand(10000, 99999);
            } while ($codes->contains($code));

            $model->code = $code;
            $model->expiry_time = now()->addMinutes(10);
        });
    }
}
