<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductAttributeValue extends Model
{
    protected $fillable = [
        'product_id',
        'category_attribute_id',
        'value',
    ];

    protected $with = [
        'attribute',
    ];

    public function getLabelAttribute(): string
    {
        return $this->attribute->label ?? '';
    }
    /**
     * The part below is for this model relationships
     */
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function attribute(): BelongsTo
    {
        return $this->belongsTo(CategoryAttribute::class, 'category_attribute_id');
    }
    /**
     * The above is for this model relationships
     */
}
