<?php

namespace App\Services;

use App\Models\User;
use Illuminate\Auth\Events\Registered;

class UserService
{
    public static function registerIfNotExist(string $phone): User
    {
        $user = static::findByPhone($phone);

        if (is_null($user)) {
            $user = static::registerNewUser([
                'phone' => $phone,
                'username' => $phone,
            ]);

            event(new Registered($user));
        }

        
        return $user;
    }

    public static function findByPhone(string $phone): ?User
    {
        return User::wherePhone($phone)->first();
    }

    public static function registerNewUser(array $data, string $role = 'client'): User
    {
        $user = User::create($data);
        $user->assignRole($role);

        return $user;
    }
}
