<?php

namespace App\Traits;

use App\Models\Like;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use PhpOffice\PhpSpreadsheet\Calculation\Logical\Boolean;

trait Likeable
{
    /**
     * Get the relationship for likes.
     */
    public function likes(): MorphMany
    {
        return $this->morphMany(Like::class, 'likeable');
    }

    /**
     * Check if the model has been liked by a specific user.
     */
    public function isLikedBy(User|int $user): bool
    {
        $userId = $user instanceof Model ? $user->id : $user;

        return $this->likes()->where('user_id', $userId)->exists();
    }

    /**
     * Like the model by a specific user.
     */
    public function like(User|int $user): bool
    {
        $userId = $user instanceof Model ? $user->id : $user;

        if (!$this->isLikedBy($userId)) {
            $this->likes()->create(['user_id' => $userId]);
        }

        return true;
    }

    /**
     * Dislike the model by a specific user.
     */
    public function dislike(User|int $user): bool
    {
        $userId = $user instanceof Model ? $user->id : $user;

        $like = $this->likes()->where('user_id', $userId)->first()->delete();
        return true;
    }

    /**
     * Get the count of likes for the model.
     */
    // public function likesCount(): int
    // {
    //     return $this->likes()->count();
    // }
}
