<?php

namespace App\View\Components\Blesser\Element;

use Closure;
use App\Models\Product;
use Illuminate\View\Component;
use App\Enums\ProductStatusEnum;
use Illuminate\Contracts\View\View;

class ProductSliderList extends Component
{
    public $title;
    public $products;

    /**
     * Create a new component instance.
     */
    public function __construct($title = 'داغ ترین چند ساعت گذشته', $config = [])
    {
        $query = Product::where('status', ProductStatusEnum::Published);

        // Example of using config to filter hot products
        if (isset($config['where'])) {
            foreach ($config['where'] as $field => $value) {
                $query->where($field, $value);
            }
        }

        $query->latest()->take($config['take'] ?? 12);

        $this->title = $title;
        $this->products = $query->get()->map(function ($product) {
            return [
                'title' => $product->title,
                'image' => $product->brand_img,
                'url' => route('product.details', $product->slug),
            ];
        });
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.blesser.element.product-slider-list');
    }
}
