<?php

namespace App\View\Components\Syndron;

use App\Models\Shop;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class AdminSidebarMenu extends Component
{
    public $items = [];

    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        $this->items = $this->getMenuItems();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.syndron.admin-sidebar-menu');
    }

    private function getMenuItems(): array
    {
        return [
            [
                'name' => __('Dashboard'),
                'is_url' => false,
                'route' => 'admin.dashboard',
                'permission' => 'dashboard.view',
                'url' => null,
                'icon' => 'bx bx-home-alt',
                'children' => [],
            ],
            [
                'name' => __('Dashboard'),
                'is_url' => false,
                'route' => 'admin.shop.dashboard',
                'permission' => 'dashboard.shop.view',
                'url' => null,
                'icon' => 'bx bx-home-alt',
                'children' => [],
            ],
            [
                'name' => __('Sale Overview'),
                'is_url' => false,
                'route' => 'admin.shop.overview.sale',
                'permission' => 'dashboard.shop.view',
                'url' => null,
                'icon' => 'bx bx-chart',
                'children' => [],
            ],
            [
                'name' => __('Shop Setting'),
                'is_url' => false,
                'route' => 'admin.shop.setting',
                'permission' => 'admin.shop.profile.update',
                'url' => null,
                'icon' => 'bx bx-home-alt',
                'children' => [],
            ],
            [
                'name' => __('WooCommerce'),
                'is_url' => false,
                'condition' => fn() => (module()->get('woocommerce-sync')?->isActive() ?? false) && auth()->user()->shop->isShopWooCommerceCredentialExist(),
                'route' => null,
                'permission' => null,
                'url' => null,
                'icon' => null,
                'image' => url('assets/images/woocommerce-icon.webp'),
                'children' => [
                    [
                        'name' => __('Product list'),
                        'is_url' => false,
                        'route' => 'admin.shop.woocommerce.product.list',
                        'permission' => null,
                        'url' => null,
                        'icon' => 'bx bx-cog',
                    ],
                    [
                        'name' => __('Order list'),
                        'is_url' => false,
                        'route' => 'admin.shop.woocommerce.order.list',
                        'permission' => null,
                        'url' => null,
                        'icon' => 'bx bx-cog',
                    ],
                    [
                        'name' => __('Customer list'),
                        'is_url' => false,
                        'route' => 'admin.shop.woocommerce.customer.list',
                        'permission' => null,
                        'url' => null,
                        'icon' => 'bx bx-user',
                    ],
                ],
            ],

            [
                'name' => __('Categories'),
                'is_url' => false,
                'route' => 'admin.categories.index',
                'permission' => 'category.view',
                'url' => null,
                'icon' => 'bx bx-category',
                'children' => [],
            ],
            [
                'name' => __('Tags'),
                'is_url' => false,
                'route' => 'admin.tags.index',
                'permission' => 'tag.view',
                'url' => null,
                'icon' => 'bx bx-category',
                'children' => [],
            ],
            [
                'name' => __('Brands'),
                'is_url' => false,
                'route' => 'admin.brands.index',
                'permission' => 'brand.view',
                'url' => null,
                'icon' => 'bx bx-category',
                'children' => [],
            ],
            [
                'name' => __('Products'),
                'is_url' => false,
                'query' => ['show' => 'list'],
                'route' => 'admin.product.index',
                'permission' => 'product.view',
                'url' => null,
                'icon' => 'bx bx-box ',
                'children' => [],
            ],
            [
                'name' => __('Orders'),
                'is_url' => false,
                'route' => 'admin.orders.index',
                'permission' => 'order.view',
                'url' => null,
                'icon' => 'bx bx-box ',
                'children' => [],
            ],
            [
                'name' => __('Coupon'),
                'is_url' => false,
                'route' => 'admin.coupons.index',
                'permission' => 'coupon.view',
                'url' => null,
                'icon' => 'bx bx-box ',
                'children' => [],
            ],
            [
                'name' => __('Comments'),
                'is_url' => false,
                'route' => 'admin.comments.index',
                'query' => ['model' => 'Product'],
                'permission' => 'comment.view',
                'url' => null,
                'icon' => 'bx bx-box ',
                'children' => [],
            ],
            [
                'divider' => __('Delivery')
            ],
            [
                'name' => __('Delivery Providers'),
                'is_url' => false,
                'route' => 'admin.delivery.providers.index',
                'permission' => 'delivery_provider.view',
                'url' => null,
                'icon' => 'bx bx-box',
                'children' => [],
            ],
            [
                'name' => __('Delivery Times'),
                'is_url' => false,
                'route' => 'admin.delivery.times.index',
                'permission' => 'delivery_time.view',
                'url' => null,
                'icon' => 'bx bx-box',
                'children' => [],
            ],
            [
                'name' => __('Day Capacities'),
                'is_url' => false,
                'route' => 'admin.delivery.day-capacities.index',
                'permission' => 'day_capacity.view',
                'url' => null,
                'icon' => 'bx bx-calendar',
                'children' => [],
            ],
            [
                'name' => __('Time Reservations'),
                'is_url' => false,
                'route' => 'admin.delivery.time-reservations.index',
                'permission' => 'time_reservation.view',
                'url' => null,
                'icon' => 'bx bx-time',
                'children' => [],
            ],
            [
                'name' => __('Deliveries'),
                'is_url' => false,
                'route' => 'admin.delivery.deliveries.index',
                'permission' => 'delivery.view',
                'url' => null,
                'icon' => 'bx bx-package',
                'children' => [],
            ],
            [
                'name' => __('Order Delivery Addresses'),
                'is_url' => false,
                'route' => 'admin.delivery.order-delivery-addresses.index',
                'permission' => 'order.delivery-address.view',
                'url' => null,
                'icon' => 'bx bx-map',
                'children' => [],
            ],
            [
                'divider' => __('Shop')
            ],
            [
                'name' => __('Sell a new product'),
                'is_url' => false,
                'route' => 'admin.shop.product-selection',
                'permission' => 'product.view.own',
                'url' => null,
                'icon' => 'bx bx-box',
                'children' => [],
            ],
            [
                'name' => __('My products'),
                'is_url' => false,
                'route' => 'admin.shop.inventory.index',
                'permission' => 'product.view.own',
                'url' => null,
                'icon' => 'bx bx-box',
                'children' => [],
            ],
            [
                'name' => __('My orders'),
                'is_url' => false,
                'route' => 'admin.orders.index',
                'permission' => 'order.view.own',
                'url' => null,
                'icon' => 'bx bx-box',
                'children' => [],
            ],
            [
                'name' => __('Warehouses'),
                'is_url' => false,
                'route' => 'admin.warehouses.index',
                'url' => null,
                'icon' => 'bx bx-box',
                'children' => [],
            ],
            [
                'divider' => __('Pre Invoice')
            ],
            [
                'name' => __('Pre Invoices List'),
                'is_url' => false,
                'route' => 'admin.pre-invoice.index',
                'url' => null,
                'icon' => 'bx bx-box',
                'children' => [],
            ],
            [
                'name' => __('Accepted Quote'),
                'is_url' => false,
                'route' => 'admin.shop.pre-invoice.accepted-quote',
                'url' => null,
                'icon' => 'bx bx-box',
                'children' => [],
            ],
            [
                'divider' => __('Blog')
            ],
            [
                'name' => __('Posts'),
                'is_url' => false,
                'route' => 'admin.post.index',
                'permission' => 'post.view',
                'url' => null,
                'icon' => 'bx bx-note',
                'children' => [],
            ],
            [
                'divider' => __('Pages')
            ],
            [
                'name' => __('Page'),
                'is_url' => false,
                'route' => 'admin.page.index',
                'permission' => 'page.view',
                'url' => null,
                'icon' => 'bx bx-note',
                'children' => [],
            ],
            [
                'divider' => __('Office Equipment')
            ],
            [
                'name' => __('Groups'),
                'is_url' => false,
                'route' => 'admin.product-bundle.index',
                'permission' => 'office-equipment-group.view',
                'url' => null,
                'icon' => 'bx bx-note',
                'children' => [],
            ],
            [
                'divider' => __('F&Q')
            ],
            [
                'name' => __('Categories'),
                'is_url' => false,
                'route' => 'admin.faq.categories.index',
                'permission' => 'faq.category.view',
                'url' => null,
                'icon' => 'bx bx-category',
                'children' => [],
            ],
            [
                'name' => __('Tags'),
                'is_url' => false,
                'route' => 'admin.faq.tags.index',
                'permission' => 'faq.tag.view',
                'url' => null,
                'icon' => 'bx bx-tag',
                'children' => [],
            ],
            [
                'name' => __('Questions'),
                'is_url' => false,
                'route' => 'admin.faq.questions.index',
                'permission' => 'faq.question.view',
                'url' => null,
                'icon' => 'bx bx-question-mark',
                'children' => [],
            ],
            [
                'name' => __('Reports'),
                'is_url' => false,
                'route' => 'admin.faq.flags.index',
                'permission' => 'faq.report.view',
                'url' => null,
                'icon' => 'bx bx-flag',
                'children' => [],
            ],
            [
                'divider' => __('Storage')
            ],
            [
                'name' => __('file manager'),
                'is_url' => false,
                'route' => 'admin.file-manager',
                'permission' => 'file.manager.view',
                'url' => null,
                'icon' => 'bx bx-file',
                'children' => [],
            ],
            [
                'divider' => __('Options')
            ],
            [
                'name' => __('Site Menu'),
                'is_url' => false,
                'route' => 'admin.option.menu',
                'permission' => 'option.panel.view',
                'url' => null,
                'icon' => 'bx bx-cog',
                'children' => [],
            ],
            [
                'name' => __('options panel'),
                'is_url' => false,
                'route' => 'admin.option.panel-v2',
                'permission' => 'option.panel.view',
                'url' => null,
                'icon' => 'bx bx-cog',
                'children' => [],
            ],
            [
                'name' => __('option'),
                'is_url' => false,
                'route' => 'admin.option.group-index',
                'permission' => 'option.view',
                'url' => null,
                'icon' => 'bx bx-cog',
                'children' => [],
            ],
            [
                'divider' => __('Settings')
            ],
            [
                'name' => __('Loyalty'),
                'condition' => fn() => module()->get('loyalty-system')?->isActive() ??  false,
                'is_url' => false,
                'route' => 'admin.loyalty.dashboard',
                'permission' => 'user.view',
                'url' => null,
                'icon' => 'bx bx-user-circle',
                'children' => [],
            ],
            [
                'name' => __('User'),
                'is_url' => false,
                'route' => 'admin.settings.users.index',
                'permission' => 'user.view',
                'url' => null,
                'icon' => 'bx bx-user-circle',
                'children' => [],
            ],
            [
                'name' => __('Shops'),
                'is_url' => false,
                'route' => 'admin.shops.index',
                'permission' => 'shop.view',
                'url' => null,
                'icon' => 'bx bx-store',
                'children' => [],
            ],
            [
                'name' => __('Roles'),
                'is_url' => false,
                'route' => 'admin.settings.role.index',
                'permission' => 'role.view',
                'url' => null,
                'icon' => 'bx bx-shield',
                'children' => [],
            ],
            [
                'name' => __('Permissions'),
                'is_url' => false,
                'route' => 'admin.settings.permission.index',
                'permission' => 'permission.view',
                'url' => null,
                'icon' => 'bx bx-shield',
                'children' => [],
            ],
            [
                'name' => __('Import Data'),
                'is_url' => false,
                'route' => 'admin.settings.data.import.index',
                'permission' => 'import.view',
                'url' => null,
                'icon' => 'bx bx-shield',
                'children' => [],
            ],
            [
                'name' => __('Export Data'),
                'is_url' => false,
                'route' => 'admin.settings.data.export.index',
                'permission' => 'export.view',
                'url' => null,
                'icon' => 'bx bx-shield',
                'children' => [],
            ],
            [
                'name' => __('Modules'),
                'is_url' => false,
                'route' => 'admin.modules.index',
                'permission' => 'modules.view',
                'url' => null,
                'icon' => 'bx bx-shield',
                'children' => [],
            ],
            [
                'divider' => __('UI Settings')
            ],
            [
                'name' => __('footer sections'),
                'is_url' => false,
                'route' => 'admin.settings.ui.footer-sections.index',
                'permission' => 'footer.section.view',
                'url' => null,
                'icon' => 'bx bx-brush',
                'children' => [],
            ],
            [
                'divider' => __('Developer')
            ],
            [
                'name' => __('Cache'),
                'is_url' => false,
                'route' => 'admin.settings.cache.index',
                'permission' => 'cache.view',
                'url' => null,
                'icon' => 'bx bx-cog',
                'children' => [],
            ],
            [
                'name' => __('Site Status'),
                'is_url' => false,
                'route' => 'telescope',
                'permission' => 'site.status.view',
                'url' => null,
                'icon' => 'bx bx-cog',
                'children' => [],
            ],
            [
                'name' => __('Site log'),
                'is_url' => false,
                'route' => 'log-viewer.index',
                'permission' => 'site.log.view',
                'url' => null,
                'icon' => 'bx bx-cog',
                'children' => [],
            ],
            [
                'name' => __('tasks'),
                'is_url' => false,
                'route' => 'admin.tasks',
                'permission' => 'site.log.view',
                'url' => null,
                'icon' => 'bx bx-cog',
                'children' => [],
            ],
            [
                'divider' => __('UI')
            ],
            [
                'name' => __('Components'),
                'is_url' => false,
                'route' => null,
                'permission' => 'component.view',
                'url' => null,
                'icon' => 'bx bx-cog',
                'children' => [
                    [
                        'name' => __('alert'),
                        'is_url' => false,
                        'route' => 'admin.template.components.alerts',
                        'permission' => 'component.alert.view',
                        'url' => null,
                        'icon' => 'bx bx-cog',
                    ],
                    [
                        'name' => __('tab'),
                        'is_url' => false,
                        'route' => 'admin.template.components.tabs',
                        'permission' => 'component.tab.view',
                        'url' => null,
                        'icon' => 'bx bx-cog',
                    ],
                    [
                        'name' => __('datepicker'),
                        'is_url' => false,
                        'route' => 'admin.template.components.datepicker',
                        'permission' => 'component.datepicker.view',
                        'url' => null,
                        'icon' => 'bx bx-cog',
                    ],
                ],
            ],


        ];
    }
}
