<?php

use App\Http\Middleware\LanguageManagerMiddleware;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Support\Facades\Route;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        api: __DIR__ . '/../routes/api.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
        then: function () {
            Route::middleware(['web', 'auth'])
                ->prefix('admin')
                ->name('admin.')
                ->group(function () {
                    foreach (glob(base_path('routes/admin/*.php')) as $routeFile) {
                        require $routeFile;
                    }
                });

            Route::middleware(['web', 'auth'])
                ->prefix('user')
                ->name('user.')
                ->group(base_path('routes/user.php'));

            Route::middleware(['web', 'auth'])
                ->prefix('shop')
                ->name('shop.')
                ->group(base_path('routes/shop.php'));

            Route::middleware(['web'])
                ->prefix('development')
                ->name('development.')
                ->group(base_path('routes/development.php'));


            if (env('APP_ENV') !== 'production' && env('APP_DEBUG') === true) {
                Route::middleware(['web'])
                    ->prefix('test')
                    ->name('test.')
                    ->group(base_path('routes/test.php'));
            }
        },
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'role' => \Spatie\Permission\Middleware\RoleMiddleware::class,
            'permission' => \Spatie\Permission\Middleware\PermissionMiddleware::class,
            'role_or_permission' => \Spatie\Permission\Middleware\RoleOrPermissionMiddleware::class,
            'module' => \App\Http\Middleware\CheckModuleActive::class,
        ]);

        $middleware->web(append: [
            LanguageManagerMiddleware::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
