<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('addresses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('address');
            $table->string('province');
            $table->string('city');
            $table->string('neighborhood')->nullable();
            $table->string('plaque');
            $table->string('unit')->nullable();
            $table->string('zip_code');
            $table->string('latitude')->nullable();
            $table->string('longitude')->nullable();
            $table->boolean('owner_is_receiver')->nullable()->default(1);
            $table->string('receiver_name')->nullable();
            $table->string('receiver_phone')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('addresses');
    }
};
