<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('category_attributes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained()->cascadeOnDelete();

            $table->string('label');
            $table->string('type')->nullable()->default('text');
            $table->string('name');
            $table->string('default_value')->nullable();
            $table->boolean('is_required')->nullable()->default(0);

            $table->boolean('is_filterable')->nullable()->default(0);
            $table->string('filter_type')->nullable()->default('text');

            $table->boolean('is_price_effective')->nullable()->default(0);
            $table->string('validation')->nullable();
            $table->auditable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_attributes');
    }
};
