<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('category_attribute_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_attribute_id')->constrained();
            $table->string('item_group')->nullable();
            $table->string('item_key')->nullable();
            $table->string('item_value')->nullable();
            $table->json('data')->nullable();
            $table->auditable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_attribute_items');
    }
};
