<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->id();

            // general info
            $table->string('code')->unique();
            $table->text('description')->nullable();
            $table->enum('type', ['Percentage Discount', 'Fixed Cart Discount', 'Fixed Product Discount']);
            $table->decimal('amount', 10, 2);
            $table->boolean('allow_free_shipment')->default(false);
            $table->timestamp('expire_date')->nullable();

            // usage restriction
            $table->decimal('max_discount', 10, 2)->nullable();
            $table->decimal('minimum_spend', 10, 2)->nullable();
            $table->decimal('maximum_spend', 10, 2)->nullable();

            $table->boolean('individual_use_only')->default(false);
            $table->boolean('exclude_sale_items')->default(false);

            $table->json('products')->nullable();
            $table->json('exclude_products')->nullable();
            $table->json('product_categories')->nullable();
            $table->json('exclude_categories')->nullable();
            $table->json('allowed_emails')->nullable();

            // usage limits
            $table->unsignedInteger('usage_limit')->nullable();
            $table->unsignedInteger('product_limit')->nullable(); // Usage limit per item in cart
            $table->unsignedInteger('usage_limit_per_user')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupons');
    }
};
