<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('delivery_providers', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();       // e.g. "DHL", "DPD", "InHouse"
            $table->string('code')->nullable();     // e.g. "DHL_DE", "DPD_UK"
            $table->string('contact_phone')->nullable();
            $table->string('contact_email')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });

        // Add provider_id FK to deliveries (nullable for legacy records)
        Schema::table('deliveries', function (Blueprint $table) {
            $table->foreignId('provider_id')
                  ->nullable()
                  ->after('type')
                  ->constrained('delivery_providers')
                  ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('deliveries', function (Blueprint $table) {
            $table->dropConstrainedForeignId('provider_id');
        });
        Schema::dropIfExists('delivery_providers');
    }
};
