<?php
// 2025_06_05_000002_create_delivery_events_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('delivery_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('delivery_id')
                ->constrained('deliveries')
                ->cascadeOnDelete();
            $table->enum('status', [
                'pending',
                'ready_for_pickup',
                'in_transit',
                'out_for_delivery',
                'delivered',
                'failed',
                'returned'
            ])->index();
            $table->json('payload')->nullable();
            $table->dateTime('happened_at')->index();
            $table->timestamps();
        });

        // Optionally, an index on (delivery_id, happened_at) for fast timeline lookups
        Schema::table('delivery_events', function (Blueprint $table) {
            $table->index(['delivery_id', 'happened_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('delivery_events');
    }
};
