<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('pages', function (Blueprint $table) {
            if (!Schema::hasColumn('pages', 'css'))            $table->longText('css')->nullable()->after('content');
            if (!Schema::hasColumn('pages', 'js'))            $table->longText('js')->nullable()->after('css');
            if (!Schema::hasColumn('pages', 'components_json')) $table->longText('components_json')->nullable()->after('js');
            if (!Schema::hasColumn('pages', 'styles_json'))    $table->longText('styles_json')->nullable()->after('components_json');
            if (!Schema::hasColumn('pages', 'assets_json'))    $table->json('assets_json')->nullable()->after('styles_json');
            if (!Schema::hasColumn('pages', 'gjs_source'))    $table->json('gjs_source')->nullable()->after('assets_json');
            if (!Schema::hasColumn('pages', 'published_html')) $table->longText('published_html')->nullable()->after('is_published');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pages', function (Blueprint  $table) {
            $table->dropColumn(['css', 'components_json', 'styles_json', 'assets_json', 'published_html', 'gjs_source', 'js']);
        });
    }
};
