<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('shops', function (Blueprint $table) {
            $table->after('approved_at', function (Blueprint $table) {
                if (!Schema::hasColumn('shops', 'consumer_key'))    $table->longText('consumer_key')->nullable();
                if (!Schema::hasColumn('shops', 'consumer_secret')) $table->longText('consumer_secret')->nullable();
                if (!Schema::hasColumn('shops', 'woo_url')) $table->longText('woo_url')->nullable();
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('shops', function (Blueprint  $table) {
            $table->dropColumn(['consumer_key', 'consumer_secret','woo_url']);
        });
    }
};
