<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('otps', function (Blueprint $table) {
            $table->after('code', function (Blueprint $table) {
                if (!Schema::hasColumn('otps', 'service'))    $table->string('service')->nullable();
                if (!Schema::hasColumn('otps', 'token'))      $table->longText('token')->nullable();
                if (!Schema::hasColumn('otps', 'identifier')) $table->string('identifier')->nullable();
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('otps', function (Blueprint  $table) {
            $table->dropColumn(['service', 'token', 'identifier']);
        });
    }
};
