<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up(): void
    {
        Schema::table(prefixedTable('questions'), function (Blueprint $table) {
            $table->foreign('best_answer_id')
                ->references('id')
                ->on(prefixedTable('answers'))
                ->onDelete('set null');
        });
        
        Schema::table(prefixedTable('answers'), function (Blueprint $table) {
            $table->foreign('question_id')
                ->references('id')
                ->on(prefixedTable('questions'))
                ->onDelete('cascade');
        });
    }
    
    public function down(): void
    {
        Schema::table(prefixedTable('questions'), function (Blueprint $table) {
            $table->dropForeign(['category_id']);
            $table->dropForeign(['best_answer_id']);
        });
        
        Schema::table(prefixedTable('answers'), function (Blueprint $table) {
            $table->dropForeign(['question_id']);
        });
    }
};
