<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;

class CategorySeeder extends Seeder
{
    public function run()
    {
        $categories = [
            // Top-level categories
            ['name' => 'دندان‌پزشکی ترمیمی',           'parent_id' => 0, 'commission' => 0, 'order_index' => 1,  'image' => null],
            ['name' => 'اندودنتیکس و جراحی',           'parent_id' => 0, 'commission' => 0, 'order_index' => 2,  'image' => null],
            ['name' => 'مراقبت پیشگیرانه',            'parent_id' => 0, 'commission' => 0, 'order_index' => 3,  'image' => null],
            ['name' => 'تصویربرداری و تشخیص',         'parent_id' => 0, 'commission' => 0, 'order_index' => 4,  'image' => null],
            ['name' => 'کنترل عفونت',                  'parent_id' => 0, 'commission' => 0, 'order_index' => 5,  'image' => null],
            ['name' => 'مواد قالب‌گیری و آزمایشگاهی',  'parent_id' => 0, 'commission' => 0, 'order_index' => 6,  'image' => null],
            ['name' => 'تجهیزات و وسایل درمانی',       'parent_id' => 0, 'commission' => 0, 'order_index' => 7,  'image' => null],
            ['name' => 'پروتز و ارتودنسی',             'parent_id' => 0, 'commission' => 0, 'order_index' => 8,  'image' => null],
            ['name' => 'مصرفی‌ها و متفرقه',            'parent_id' => 0, 'commission' => 0, 'order_index' => 9,  'image' => null],
            ['name' => 'دارویی و بی‌حسی',              'parent_id' => 0, 'commission' => 0, 'order_index' => 10, 'image' => null],
            ['name' => 'ابزارهای تراش و برش',         'parent_id' => 0, 'commission' => 0, 'order_index' => 11, 'image' => null],
            ['name' => 'فلزات و آلیاژها',              'parent_id' => 0, 'commission' => 0, 'order_index' => 12, 'image' => null],
            ['name' => 'دسته‌بندی نشده یا چندمنظوره', 'parent_id' => 0, 'commission' => 0, 'order_index' => 13, 'image' => null],

            // Sub-categories of دندان‌پزشکی ترمیمی (parent_id = 1)
            ['name' => 'مواد آکریلیک، ری‌لاین و تری',  'parent_id' => 1,  'commission' => 0, 'order_index' => 1,  'image' => null],
            ['name' => 'چسب‌ها، آسترها و سمان‌ها',      'parent_id' => 1,  'commission' => 0, 'order_index' => 2,  'image' => null],
            ['name' => 'مواد هسته‌گذاری',               'parent_id' => 1,  'commission' => 0, 'order_index' => 3,  'image' => null],
            ['name' => 'محصولات زیبایی دندانی',        'parent_id' => 1,  'commission' => 0, 'order_index' => 4,  'image' => null],
            ['name' => 'روکش‌ها، نوارها و شِل‌ها',      'parent_id' => 1,  'commission' => 0, 'order_index' => 5,  'image' => null],
            ['name' => 'مواد ماتریس و گوه‌ها',         'parent_id' => 1,  'commission' => 0, 'order_index' => 6,  'image' => null],
            ['name' => 'پین‌ها و پست‌ها',               'parent_id' => 1,  'commission' => 0, 'order_index' => 7,  'image' => null],
            ['name' => 'مواد جمع‌کننده لثه',           'parent_id' => 1,  'commission' => 0, 'order_index' => 8,  'image' => null],
            ['name' => 'محصولات رابردم',                'parent_id' => 1,  'commission' => 0, 'order_index' => 9,  'image' => null],
            ['name' => 'واکس‌ها',                      'parent_id' => 1,  'commission' => 0, 'order_index' => 10, 'image' => null],

            // Sub-categories of اندودنتیکس و جراحی (parent_id = 2)
            ['name' => 'محصولات اندودنتیک',            'parent_id' => 2,  'commission' => 0, 'order_index' => 1,  'image' => null],
            ['name' => 'تجهیزات جراحی',               'parent_id' => 2,  'commission' => 0, 'order_index' => 2,  'image' => null],
            ['name' => 'محصولات مرتبط با ایمپلنت',     'parent_id' => 2,  'commission' => 0, 'order_index' => 3,  'image' => null],
            ['name' => 'محصولات اضطراری',             'parent_id' => 2,  'commission' => 0, 'order_index' => 4,  'image' => null],

            // Sub-categories of مراقبت پیشگیرانه (parent_id = 3)
            ['name' => 'محصولات پیشگیری',              'parent_id' => 3,  'commission' => 0, 'order_index' => 1,  'image' => null],
            ['name' => 'راحتی و محافظت بیمار',         'parent_id' => 3,  'commission' => 0, 'order_index' => 2,  'image' => null],
            ['name' => 'محصولات آموزشی سلامت دهان',   'parent_id' => 3,  'commission' => 0, 'order_index' => 3,  'image' => null],

            // Sub-categories of تصویربرداری و تشخیص (parent_id = 4)
            ['name' => 'محصولات رادیولوژی (اشعه ایکس)', 'parent_id' => 4,  'commission' => 0, 'order_index' => 1,  'image' => null],
            ['name' => 'لوپ‌ها، ذره‌بین‌ها و چراغ‌های پیشانی', 'parent_id' => 4, 'commission' => 0, 'order_index' => 2, 'image' => null],

            // Sub-categories of کنترل عفونت (parent_id = 5)
            ['name' => 'محصولات کنترل عفونت - کلینیکی', 'parent_id' => 5, 'commission' => 0, 'order_index' => 1,  'image' => null],
            ['name' => 'محصولات کنترل عفونت - شخصی',   'parent_id' => 5, 'commission' => 0, 'order_index' => 2,  'image' => null],

            // Sub-categories of مواد قالب‌گیری و آزمایشگاهی (parent_id = 6)
            ['name' => 'مواد قالب‌گیری',               'parent_id' => 6, 'commission' => 0, 'order_index' => 1,  'image' => null],
            ['name' => 'مواد مخلوط‌سازی',             'parent_id' => 6, 'commission' => 0, 'order_index' => 2,  'image' => null],
            ['name' => 'محصولات آزمایشگاهی',          'parent_id' => 6, 'commission' => 0, 'order_index' => 3,  'image' => null],

            // Sub-categories of تجهیزات و وسایل درمانی (parent_id = 7)
            ['name' => 'هندپیس‌ها',                    'parent_id' => 7, 'commission' => 0, 'order_index' => 1,  'image' => null],
            ['name' => 'تجهیزات دندان‌پزشکی',          'parent_id' => 7, 'commission' => 0, 'order_index' => 2,  'image' => null],
            ['name' => 'محصولات تخلیه و ساکشن',         'parent_id' => 7, 'commission' => 0, 'order_index' => 3,  'image' => null],
            ['name' => 'مواد آرتیکولاسیون و لوازم جانبی', 'parent_id' => 7, 'commission' => 0, 'order_index' => 4, 'image' => null],
            ['name' => 'محصولات پرداخت و فینیشینگ',    'parent_id' => 7, 'commission' => 0, 'order_index' => 5,  'image' => null],

            // Sub-categories of پروتز و ارتودنسی (parent_id = 8)
            ['name' => 'محصولات ارتودنسی',             'parent_id' => 8, 'commission' => 0, 'order_index' => 1,  'image' => null],
            ['name' => 'محصولات CAD/CAM',             'parent_id' => 8, 'commission' => 0, 'order_index' => 2,  'image' => null],

            // Sub-categories of مصرفی‌ها و متفرقه (parent_id = 9)
            ['name' => 'محصولات یک‌بار مصرف',          'parent_id' => 9, 'commission' => 0, 'order_index' => 1,  'image' => null],
            ['name' => 'لوازم اداری و جانبی',        'parent_id' => 9, 'commission' => 0, 'order_index' => 2,  'image' => null],
            ['name' => 'محصولات متفرقه',             'parent_id' => 9, 'commission' => 0, 'order_index' => 3,  'image' => null],
            ['name' => 'هدایا و اقلام خاص',          'parent_id' => 9, 'commission' => 0, 'order_index' => 4,  'image' => null],

            // Sub-categories of دارویی و بی‌حسی (parent_id = 10)
            ['name' => 'محصولات بی‌حسی',              'parent_id' => 10, 'commission' => 0, 'order_index' => 1,  'image' => null],
            ['name' => 'محصولات دارویی',             'parent_id' => 10, 'commission' => 0, 'order_index' => 2,  'image' => null],
            ['name' => 'سرنگ‌ها و سوزن‌های پزشکی',    'parent_id' => 10, 'commission' => 0, 'order_index' => 3,  'image' => null],

            // Sub-categories of ابزارهای تراش و برش (parent_id = 11)
            ['name' => 'بورها و فرزهای الماسی',        'parent_id' => 11, 'commission' => 0, 'order_index' => 1,  'image' => null],

            // Sub-categories of فلزات و آلیاژها (parent_id = 12)
            ['name' => 'آلیاژها و لوازم جانبی',       'parent_id' => 12, 'commission' => 0, 'order_index' => 1,  'image' => null],

            // Sub-categories of دسته‌بندی نشده یا چندمنظوره (parent_id = 13)
            ['name' => 'ابزارهای دندان‌پزشکی',        'parent_id' => 13, 'commission' => 0, 'order_index' => 1,  'image' => null],
        ];
        foreach ($categories as $categoryData) {
            Category::create($categoryData);
        }
    }
}
