<?php

namespace Database\Seeders;

use App\Models\Shop;
use App\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        foreach (['Administrator', 'Admin', 'Shop', 'Client', 'Developer'] as $key => $value) {
            $user = User::create([
                'name' => 'User ' . $value,
                'username' => 'user-' . $value,
                'email' => 'user' . $value . '@example.com',
                'phone' => rand(9000000000, 9999999999), // Random phone number
                'password' => bcrypt('password'),
            ]);
            event(new Registered($user));

            $user->assignRole($value);

            if ($value == 'Shop') {
                $shop = Shop::create(
                    [
                        'user_id' => $user->id,
                        'name' => 'shop Shop',
                        'slug' => 'shop-shop',
                        'logo' => 'default-logo.png',
                        'description' => 'This is the shop of shop.',
                        'phone' => '09228422123',
                        'email' => 'shop@shop.com',
                        'address' => '123 Main Street',
                        'city' => 'Tehran',
                        'state' => 'Tehran',
                        'postal_code' => '1234567890',
                        'country' => 'Iran',
                        'is_approved' => true,
                        'approved_at' => now(),
                    ]
                );
            }
        }
    }
}
