export function initFormAjaxInputs() {
    // Delegate submit handling for any form with class "use-ajax"
    document.addEventListener('submit', function (event) {
        const form = event.target;
        if (!form.matches('form.use-ajax')) return;

        event.preventDefault();

        const url = form.action;
        const method = form.method.toUpperCase() || 'POST';
        const formData = new FormData(form);

        // Append extra AJAX identifier
        formData.append('ajax', 'true');

        fetch(url, {
            method: method,
            body: formData,
            credentials: 'same-origin',
            headers: {
                'Accept': 'application/json' // Add Accept header
            }
        })
            .then(response => {
                if (!response.ok) {
                    return response.text().then(text => Promise.reject(text));
                }
                return response.json(); // or .text(), depending on your response type
            })
            .then(data => {
                console.log('Success:', data);
                // TODO: handle success (e.g., show a message, redirect, etc.)

                Toast.fire({
                    icon: "success",
                    title: data.data.message || data.message || 'Success!'
                });
            })
            .catch(errorText => {
                let response = JSON.parse(errorText);
                console.log('error:', response);
                Toast.fire({
                    icon: "error",
                    title: response.message || 'Error!'
                });
            });
    });
}
