import React, { useEffect, useState } from "react";
import { createRoot } from "react-dom/client";
import axios from "axios";

function PanelPage() {
    const [groupedOptions, setGroupedOptions] = useState({});
    const [currentGroup, setCurrentGroup] = useState("");
    const [newFields, setNewFields] = useState({});

    useEffect(() => {
        axios
            .get("/admin/option/panel", {
                params: { ajax: true },
                headers: {
                    "X-CSRF-TOKEN": document.querySelector(
                        'meta[name="csrf-token"]',
                    ).content,
                },
            })
            .then((response) => {
                const items = response.data.data.options || [];
                const grouped = items.reduce((acc, option) => {
                    try {
                        option.data = option.data
                            ? JSON.parse(option.data)
                            : {};
                    } catch {
                        option.data = {};
                    }
                    acc[option.group] = acc[option.group] || [];
                    acc[option.group].push(option);
                    return acc;
                }, {});

                setGroupedOptions(grouped);
                setCurrentGroup(Object.keys(grouped)[0] || "");
            })
            .catch((error) => {
                console.error("Error loading option data:", error);
            });
    }, []);

    const updateField = (group, id, key, value) => {
        setGroupedOptions((prev) => {
            const updated = { ...prev };
            updated[group] = updated[group].map((item) =>
                item.id === id ? { ...item, [key]: value } : item,
            );
            return updated;
        });
    };

    const updateData = (group, id, key, subkey, value) => {
        setGroupedOptions((prev) => {
            const updated = { ...prev };
            updated[group] = updated[group].map((item) => {
                if (item.id === id) {
                    const newItem = { ...item };
                    newItem.data = { ...newItem.data };
                    if (!newItem.data[key]) newItem.data[key] = [{}];
                    newItem.data[key] = newItem.data[key].map((entry, idx) =>
                        idx === 0 ? { ...entry, [subkey]: value } : entry,
                    );
                    return newItem;
                }
                return item;
            });
            return updated;
        });
    };

    const addNewKey = (group, id) => {
        const { key, type } = newFields[id] || {};
        if (!key) return;
        setGroupedOptions((prev) => {
            const updated = { ...prev };
            updated[group] = updated[group].map((item) => {
                if (item.id === id) {
                    const newItem = { ...item };
                    newItem.data = {
                        ...newItem.data,
                        [key]: type === "array" ? [{}] : "",
                    };
                    return newItem;
                }
                return item;
            });
            return updated;
        });
        setNewFields((prev) => ({
            ...prev,
            [id]: { key: "", type: "string" },
        }));
    };

    const submit = () => {
        axios
            .post(
                "/admin/option/update-all",
                { groupedOptions },
                {
                    headers: {
                        "X-CSRF-TOKEN": document.querySelector(
                            'meta[name="csrf-token"]',
                        ).content,
                    },
                },
            )
            .then(() => alert("Updated successfully!"))
            .catch((error) => console.error("Update failed:", error));
    };

    return (
        <div className="row">
            <div className="col-md-3">
                <div className="list-group">
                    {Object.keys(groupedOptions).map((group) => (
                        <button
                            key={group}
                            onClick={() => setCurrentGroup(group)}
                            className={`list-group-item list-group-item-action ${currentGroup === group ? "active" : ""}`}
                        >
                            {group}
                        </button>
                    ))}
                </div>
            </div>
            <div className="col-md-9">
                {groupedOptions[currentGroup]?.map((item) => (
                    <div className="card mb-3" key={item.id}>
                        <div className="card-body">
                            <input
                                className="form-control mb-2"
                                placeholder="Key"
                                value={item.key}
                                onChange={(e) =>
                                    updateField(
                                        currentGroup,
                                        item.id,
                                        "key",
                                        e.target.value,
                                    )
                                }
                            />
                            <input
                                className="form-control mb-2"
                                placeholder="Value"
                                value={item.value}
                                onChange={(e) =>
                                    updateField(
                                        currentGroup,
                                        item.id,
                                        "value",
                                        e.target.value,
                                    )
                                }
                            />
                            {Object.entries(item.data || {}).map(
                                ([key, val]) => (
                                    <div key={key} className="mb-2">
                                        <strong>{key}</strong>
                                        {Array.isArray(val) &&
                                        val[0] &&
                                        typeof val[0] === "object" ? (
                                            Object.entries(val[0]).map(
                                                ([subkey, subval]) => (
                                                    <input
                                                        key={subkey}
                                                        className="form-control mt-1"
                                                        placeholder={subkey}
                                                        value={subval}
                                                        onChange={(e) =>
                                                            updateData(
                                                                currentGroup,
                                                                item.id,
                                                                key,
                                                                subkey,
                                                                e.target.value,
                                                            )
                                                        }
                                                    />
                                                ),
                                            )
                                        ) : (
                                            <input
                                                className="form-control mt-1"
                                                value={val}
                                                onChange={(e) =>
                                                    updateField(
                                                        currentGroup,
                                                        item.id,
                                                        "data",
                                                        {
                                                            ...item.data,
                                                            [key]: e.target
                                                                .value,
                                                        },
                                                    )
                                                }
                                            />
                                        )}
                                    </div>
                                ),
                            )}
                            <div className="mt-3">
                                <input
                                    type="text"
                                    className="form-control mb-2"
                                    placeholder="New key"
                                    value={newFields[item.id]?.key || ""}
                                    onChange={(e) =>
                                        setNewFields((prev) => ({
                                            ...prev,
                                            [item.id]: {
                                                ...prev[item.id],
                                                key: e.target.value,
                                            },
                                        }))
                                    }
                                />
                                <select
                                    className="form-select mb-2"
                                    value={newFields[item.id]?.type || "string"}
                                    onChange={(e) =>
                                        setNewFields((prev) => ({
                                            ...prev,
                                            [item.id]: {
                                                ...prev[item.id],
                                                type: e.target.value,
                                            },
                                        }))
                                    }
                                >
                                    <option value="string">String</option>
                                    <option value="array">
                                        Array of Objects
                                    </option>
                                </select>
                                <button
                                    className="btn btn-sm btn-success"
                                    onClick={() =>
                                        addNewKey(currentGroup, item.id)
                                    }
                                >
                                    + Add New Key
                                </button>
                            </div>
                        </div>
                    </div>
                ))}
                <button className="btn btn-primary mt-4" onClick={submit}>
                    Update All
                </button>
            </div>
        </div>
    );
}

const root = createRoot(document.getElementById("react-panel-root"));
root.render(<PanelPage />);
