import './bootstrap';


import { Livewire, Alpine } from '../../vendor/livewire/livewire/dist/livewire.esm';
import Clipboard from '@ryangjchandler/alpine-clipboard'
import Swal from 'sweetalert2'
import { handleBrokenImage } from './handle-broken-image';


window.Swal = Swal;

window.app = window.app || {};
app.handleBrokenImage = handleBrokenImage;

const Toast = Swal.mixin({
    toast: true,
    position: "top-end",
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.onmouseenter = Swal.stopTimer;
        toast.onmouseleave = Swal.resumeTimer;
    }
});

window.Toast = Toast;
app.toast = Toast;

document.addEventListener('DOMContentLoaded', function () {

});


Alpine.plugin(Clipboard)
Livewire.start()
