@props(['questions'=>[]])
<div class="mb-10">
    <!-- Title -->
    <div class="mb-10 flex flex-col items-center gap-6">
        <div class="flex size-12 items-center justify-center rounded-full bg-primary/15 p-2 text-primary">
            <i class="i-solar-question-square-linear size-8"></i>
        </div>
        <p class="text-lg font-medium">
            {{ __('most asked questions') }}
        </p>
    </div>
    <!-- Questions -->
    <ul class="space-y-2">

        @if (options('faq')->isNotEmpty())
        @forelse (json_decode(options('faq')->first()->data) as $key => $question )
        <li class="relative rounded-lg border-b bg-muted" data-accordion-item="">
            <button type="button" class="w-full px-4 py-3 text-right md:px-6 md:py-5" data-accordion-button="">
                <div class="flex items-center justify-between gap-2 text-sm md:text-base">
                    <span>
                        {{ $key }}
                    </span>
                    <div class="min-w-fit">
                        <span class="i-lucide-chevron-left duration-300" data-accordion-chevron=""></span>
                    </div>
                </div>
            </button>
            <div class="relative max-h-0 overflow-hidden transition-all duration-300" data-accordion-content="">
                <div class="px-4 py-2 text-sm text-text/80 lg:text-base">
                    {{ $question }}
                </div>
            </div>
        </li>
        @empty
        @endforelse
        @endif

        @forelse ($questions as $question )
        <li class="relative rounded-lg border-b bg-muted" data-accordion-item="">
            <button type="button" class="w-full px-4 py-3 text-right md:px-6 md:py-5" data-accordion-button="">
                <div class="flex items-center justify-between gap-2 text-sm md:text-base">
                    <span>
                        {{ $question->title }}
                    </span>
                    <div class="min-w-fit">
                        <span class="i-lucide-chevron-left duration-300" data-accordion-chevron=""></span>
                    </div>
                </div>
            </button>
            <div class="relative max-h-0 overflow-hidden transition-all duration-300" data-accordion-content="">
                <div class="px-4 py-2 text-sm text-text/80 lg:text-base">
                    {{ $question->betsAnswer->body }}
                </div>
            </div>
        </li>
        @empty
        <!-- <div class="flex items-center justify-center gap-2 rounded-lg bg-muted px-4 py-6">
                        <p class="text-sm text-text/80">
                            {{ __('noting found') }}
                        </p>
                    </div> -->
        @endforelse

    </ul>
</div>
