@props(['preInvoices' => null])

@if ($preInvoices !== null)
<div class="p-6">

    <div class="overflow-x-auto bg-white  border rounded-lg shadow-sm dark:bg-secondary/0.5 dark:text-white">
        <table class="min-w-full text-sm text-gray-700">
            <thead class="bg-gray-50 border-b text-gray-600  dark:bg-secondary dark:text-white">
                <tr>
                    <th class="px-4 py-3 text-right">#</th>
                    <th class="px-4 py-3 text-right">{{ __('costumer name') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('company name') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('count') }}</th>
                    <th class="px-4 py-3 text-right">{{ __('status')  }}</th>
                    <th class="px-4 py-3 text-right">{{ __('date')  }}</th>
                    <th class="px-4 py-3 text-center">{{ __('actions')  }}</th>
                </tr>
            </thead>

            <tbody class="divide-y divide-gray-200">
                @forelse($preInvoices as $index => $invoice)
                <tr class="hover:bg-gray-50 dark:hover:bg-secondary dark:text-white">
                    <td class="px-4 py-3">{{ $loop->iteration }}</td>
                    <td class="px-4 py-3 font-medium">{{ $invoice->customer_name ?? '-' }}</td>
                    <td class="px-4 py-3">{{ $invoice->company_name ?? '-' }}</td>
                    <td class="px-4 py-3">{{ $invoice->items->count() }}</td>

                    <td class="px-4 py-3">
                        @php
                        $statusColors = [
                        'open' => 'bg-blue-100 text-blue-700',
                        'closed' => 'bg-gray-100 text-gray-700',
                        'awarded' => 'bg-green-100 text-green-700',
                        'cancelled' => 'bg-red-100 text-red-700',
                        ];
                        @endphp
                        <span class="px-2 py-1 text-xs rounded-full {{ $statusColors[$invoice->status] ?? 'bg-gray-100 text-gray-700' }}">
                            {{ __($invoice->status)  }}
                        </span>
                    </td>

                    <td class="px-4 py-3 text-sm">
                        {{ verta($invoice->created_at)->format('Y/m/d') }}
                    </td>

                    <td class="px-4 py-3 text-center">
                        <a href="{{ route('pre-invoice' , ['pre-invoice' => $invoice->id]) }}">
                            <span class="px-2 py-1 text-xs rounded-full bg-primary text-white }}">
                                {{ __('details')  }}
                            </span>
                        </a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="px-4 py-6 text-center text-gray-500">
                        {{ __('there is no pre invoice found') }}
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{-- Pagination --}}
    <div class="mt-4">
        {{ $preInvoices->links() }}
    </div>
</div>
@endif
