@props(['images' => []])

@php
$count = count($images);
$gridClass = match(true) {
$count >= 4 => 'grid-cols-2 lg:grid-cols-4',
$count == 3 => 'grid-cols-1 sm:grid-cols-2 lg:grid-cols-3',
$count == 2 => 'grid-cols-1 md:grid-cols-2',
default => 'grid-cols-1',
};
@endphp

@if ($count)
<section class="container py-10">
    <div class="grid gap-6 {{ $gridClass }}">
        @foreach ($images as $image)
        <a href="{{ $image['link'] ?? '#' }}">
            <img src="{{ $image['src'] }}" alt="{{ $image['alt'] ?? 'Banner' }}" class="rounded-lg w-full" />
        </a>
        @endforeach
    </div>
</section>
@endif
