<div
    x-data="{
        loading: false,
        message: '',
        messageType: '',
        async call(action) {
            this.loading = true;
            this.message = '';
            this.messageType = '';

            try {
                const response = await fetch(`/admin/settings/cache/${action}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]').getAttribute('content'),
                    },
                });

                const data = await response.json();

                if (response.ok) {
                    this.message = data.message || 'Action completed successfully.';
                    this.messageType = 'success';
                } else {
                    this.message = data.message || 'An unexpected error occurred.';
                    this.messageType = 'danger';
                }

            } catch (err) {
                this.message = 'An error occurred while processing the request.';
                this.messageType = 'danger';
            } finally {
                this.loading = false;
            }
        }
    }"
    class="card shadow-sm">
    <div class="card-body">
        <h5 class="card-title mb-3">{{ __('System Cache Manager') }}</h5>
        <p class="card-text text-muted">
            {{ __('Use these tools to clear or rebuild your Laravel cache (config, routes, views, and application cache).') }}
        </p>

        <!-- Buttons -->
        <div class="d-flex gap-2 mt-3">
            <button
                @click="call('clear')"
                class="btn btn-outline-danger d-flex align-items-center gap-2"
                :disabled="loading">
                <span x-show="!loading">{{ __('Clear All Cache') }}</span>
                <div x-show="loading" class="spinner-border spinner-border-sm" role="status"></div>
            </button>

            <button
                @click="call('build')"
                class="btn btn-outline-success d-flex align-items-center gap-2"
                :disabled="loading">
                <span x-show="!loading">{{ __('Cache Everything') }}</span>
                <div x-show="loading" class="spinner-border spinner-border-sm" role="status"></div>
            </button>
        </div>

        <!-- Feedback Message -->
        <template x-if="message">
            <div class="alert mt-3"
                :class="messageType === 'success' ? 'alert-success' : 'alert-danger'">
                <span x-text="message"></span>
            </div>
        </template>
    </div>
</div>
