@props(['user'])

<div class="customers-list-item d-flex align-items-center border-bottom p-2 cursor-pointer">
    <div class="">
        <img src="{{ $user->profile_image ?? '/assets/themes/blesser/images/user.png' }}" class="rounded-circle" width="46" height="46" alt="{{ $user->name ?? 'User' }}">
    </div>
    <div class="ms-2">
        <h6 class="mb-1 font-14">{{ $user->name ?? 'User Name' }}</h6>

        <div class="d-flex gap-1">
            <p class="mb-0 font-13 text-secondary">{{ $user->email ?? __('undefined') }}</p>
            (<p class="mb-0 font-13 text-secondary">{{ $user->phone ?? __('undefined') }}</p>)

        </div>
    </div>
    <div class="list-inline d-flex customers-contacts ms-auto">
        @can('settings.users.view')
        <a href="mailto:{{ $user->email ?? '#' }}" class="list-inline-item"><i class="bx bxs-envelope"></i></a>
        <a href="tel:{{ $user->phone ?? '#' }}" class="list-inline-item"><i class="bx bxs-phone"></i></a>
        <a href="{{ route('admin.settings.users.show' , $user->id) }}" class="list-inline-item"><i class="bx bxs-show"></i></a>
        @endcan
    </div>
</div>
