@props([
'warehouse' => null,
'shops' => []
])

@php
$isEdit = isset($warehouse) && $warehouse->exists;
$route = $isEdit ? route('admin.warehouses.update', $warehouse->id) : route('admin.warehouses.store');
@endphp


<div>

    <form action="{{ $route }}" method="post">
        @csrf
        @if($isEdit)
        @method('PUT')
        @endif


        <!-- shop_id -->
        <input type="text" name="shop_id" value="{{ auth()->user()->shop->id }}" hidden>
        <!-- name -->
        <x-syndron.ui.form.input-text-base
            id="name"
            name="name"
            label="Warehouse Name"
            value="{{ old('name', $warehouse->name ?? '') }}"
            divClass="mb-3" />
        <!-- code -->
        <x-syndron.ui.form.input-text-base
            id="code"
            name="code"
            label="Warehouse Code"
            value="{{ old('code', $warehouse->code ?? '') }}"
            divClass="mb-3" />

        <div class="mb-3 form-check form-switch">
            <label class="form-check-label" for="is_active">{{ __('Active') }}</label>

            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                {{ old('is_active', ($warehouse->is_active ?? true)) ? 'checked' : '' }}>
        </div>
        <!-- address -->

        <div class="row">
            <x-syndron.ui.form.input-text-base
                id="address[city]"
                name="address[city]"
                label="city"
                value="{{ old('address.city', $warehouse->address['city'] ?? '') }}"
                divClass="mb-3" />
            <x-syndron.ui.form.input-text-base
                id="address[province]"
                name="address[province]"
                label="province"
                value="{{ old('address.province', $warehouse->address['province'] ?? '') }}"
                divClass="mb-3" />
            <x-syndron.ui.form.input-text-base
                id="address[postal_code]"
                name="address[postal_code]"
                label="Postal code"
                value="{{ old('address.postal_code', $warehouse->address['postal_code'] ?? '') }}"
                divClass="mb-3" />
            <x-syndron.ui.form.input-text-base
                id="address[address]"
                name="address[address]"
                label="address"
                value="{{ old('address.address', $warehouse->address['address'] ?? '') }}"
                divClass="mb-3" />
        </div>
        <button type="submit" class="btn btn-primary">{{ $isEdit ? __('Update Warehouse') : __('Create Warehouse') }} </button>
    </form>
</div>
