@props(['id', 'image', 'name', 'value'])

<input type="checkbox" name="{{ $name }}[]" value="{{ $value }}" id="{{ $id }}" class="image-checkbox d-none">
<label for="{{ $id }}" class="image-label">
    <img src="{{ $image }}" alt="Option" class="img-fluid rounded">
</label>

@once
@push('styles')
<style>
    .image-label {
        border: 2px solid transparent;
        padding: 5px;
        border-radius: 8px;
        cursor: pointer;
        transition: border-color 0.2s ease;
    }

    .image-checkbox:checked+.image-label {
        border-color: red;
    }

    .image-label img {
        width: 120px;
        aspect-ratio: 1/1;
        object-fit: contain;
        height: auto;
        display: block;
    }
</style>
@endpush
@endonce
