<div class="p-4 mb-3">
    <div>
        <h2 class="h5 mb-2">{{__('Add Product to')}} "{{ $group->name }}"</h2>
        <input type="text" wire:model.debounce.300ms="search" class="form-control mt-2" placeholder="Search for a product...">

        @if($filteredProducts->count())
        <ul class="mt-2 list-group overflow-auto" style="max-height: 160px;">
            @foreach($filteredProducts as $product)
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                    <img src="{{ $product->brand_img }}" alt="{{ $product->title }}" class="rounded img-thumbnail me-2" style="width: 80px; height: 80px; object-fit: cover;">
                    <span>{{ $product->title }}</span>
                </div>
                <button wire:click="$set('selectedProductId', {{ $product->id }})" class="btn btn-primary ">{{__('Select')}}</button>
            </li>
            @endforeach
        </ul>
        @endif
    </div>

    @if($selectedProductId)
    <div class="border p-3 rounded mt-3">
        <p class="mb-2">{{__('Selected')}}: <strong>{{ \App\Models\Product::find($selectedProductId)?->title }}</strong></p>
        <div class="mb-1">
            <label class="form-label">{{__('Quantity')}}:</label>
            <input type="number" wire:model="quantity" min="1" class="form-control w-auto">
        </div>
        <button wire:click="addProduct" class="btn btn-success mt-2">{{__('Add to Group')}}</button>
    </div>
    @endif

    <div class="mt-4">
        <h3 class="h6 mb-2">{{__('Products in Group')}}</h3>
        <ul class="list-group">
            @foreach($groupProducts as $product)
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div>
                    <img src="{{ $product->brand_img }}" alt="{{ $product->title }}" class="rounded img-thumbnail me-2" style="width: 80px; height: 80px; object-fit: cover;">
                    <span>{{ $product->title }}</span>
                    <span class="text-muted ms-2">{{__('Qty')}}: {{ $product->pivot->quantity }}</span>
                </div>
                <button wire:click="removeProduct({{ $product->id }})" class="btn btn-danger">{{__('Remove')}}</button>
            </li>
            @endforeach
        </ul>
    </div>
</div>
