<div class="z-10 w-full py-10 xs:container">
    <div class="relative mx-auto bg-muted px-4 py-8 xs:max-w-[440px] xs:rounded-xl lg:px-10 lg:py-12">
        <div class="flex flex-col">
            <!-- logo -->
            <a href="{{ route('home') }}" class="mb-10">
                <img src="{{ asset('uploads/'.getSiteLogo()) }}" alt="logo" class="mx-auto h-10 xs:h-12" />
            </a>

            <h1 class="mb-8 text-center font-medium xs:text-lg">
                {{ __("Register") }}
            </h1>

            <!-- name -->
            <div class="mb-2 w-full space-y-3">
                <label for="name" class="relative block w-full rounded-lg border bg-muted shadow-sm duration-300 focus-within:border-primary">
                    <input wire:model="name" dir="ltr" type="text" name="name" id="name" placeholder=" " class="peer w-full rounded-lg bg-transparent p-3 text-left placeholder-transparent outline-none focus:ring-0 xs:p-4" />
                    <span class="pointer-events-none absolute start-3 -translate-y-1/2 rounded-full bg-muted px-2 text-xs text-text/80 transition-all duration-200 peer-placeholder-shown:top-1/2 peer-placeholder-shown:text-sm peer-focus:text-xs peer-focus:peer-placeholder-shown:top-0 xs:text-sm md:text-sm md:peer-placeholder-shown:text-base md:peer-focus:text-sm lg:start-5">
                        {{ __('Full name')  }}
                    </span>
                </label>
                <p class="h-5 text-sm text-warning">
                    @error('name') {{ $message }} @enderror
                </p>
            </div>
            <!-- username -->
            <div class="mb-2 w-full space-y-3">
                <label for="identifier" class="relative block w-full rounded-lg border bg-muted shadow-sm duration-300 focus-within:border-primary">
                    <input wire:model="identifier" dir="ltr" type="text" name="identifier" id="identifier" placeholder=" " class="peer w-full rounded-lg bg-transparent p-3 text-left placeholder-transparent outline-none focus:ring-0 xs:p-4" />
                    <span class="pointer-events-none absolute start-3 -translate-y-1/2 rounded-full bg-muted px-2 text-xs text-text/80 transition-all duration-200 peer-placeholder-shown:top-1/2 peer-placeholder-shown:text-sm peer-focus:text-xs peer-focus:peer-placeholder-shown:top-0 xs:text-sm md:text-sm md:peer-placeholder-shown:text-base md:peer-focus:text-sm lg:start-5">
                        {{ __('Email')  }}
                    </span>
                </label>
                <p class="h-5 text-sm text-warning">
                    @error('identifier') {{ $message }} @enderror
                </p>
            </div>
            <!-- phone -->
            <div class="mb-2 w-full space-y-3">
                <label for="phone" class="relative block w-full rounded-lg border bg-muted shadow-sm duration-300 focus-within:border-primary">
                    <input wire:model="phone" dir="ltr" type="text" name="phone" id="phone" placeholder=" " class="peer w-full rounded-lg bg-transparent p-3 text-left placeholder-transparent outline-none focus:ring-0 xs:p-4" />
                    <span class="pointer-events-none absolute start-3 -translate-y-1/2 rounded-full bg-muted px-2 text-xs text-text/80 transition-all duration-200 peer-placeholder-shown:top-1/2 peer-placeholder-shown:text-sm peer-focus:text-xs peer-focus:peer-placeholder-shown:top-0 xs:text-sm md:text-sm md:peer-placeholder-shown:text-base md:peer-focus:text-sm lg:start-5">
                        {{ __('phone')  }}
                    </span>
                </label>
                <p class="h-5 text-sm text-warning">
                    @error('phone') {{ $message }} @enderror
                </p>
            </div>
            <!-- password -->
            <div class="mb-2 w-full space-y-3">
                <label for="password" class="relative block w-full rounded-lg border bg-muted shadow-sm duration-300 focus-within:border-primary">
                    <input wire:model="password" dir="ltr" type="password" name="password" id="password" placeholder=" " class="peer w-full rounded-lg bg-transparent p-3 text-left placeholder-transparent outline-none focus:ring-0 xs:p-4" />
                    <span class="pointer-events-none absolute start-3 -translate-y-1/2 rounded-full bg-muted px-2 text-xs text-text/80 transition-all duration-200 peer-placeholder-shown:top-1/2 peer-placeholder-shown:text-sm peer-focus:text-xs peer-focus:peer-placeholder-shown:top-0 xs:text-sm md:text-sm md:peer-placeholder-shown:text-base md:peer-focus:text-sm lg:start-5">
                        {{ __('*******')  }}
                    </span>
                </label>
                <p class="h-5 text-sm text-warning">
                    @error('password') {{ $message }} @enderror
                </p>
            </div>
            <div class="mb-2 w-full space-y-3">
                <label for="passwordConfirmation" class="relative block w-full rounded-lg border bg-muted shadow-sm duration-300 focus-within:border-primary">
                    <input wire:model="passwordConfirmation" dir="ltr" type="password" name="passwordConfirmation" id="passwordConfirmation" placeholder=" " class="peer w-full rounded-lg bg-transparent p-3 text-left placeholder-transparent outline-none focus:ring-0 xs:p-4" />
                    <span class="pointer-events-none absolute start-3 -translate-y-1/2 rounded-full bg-muted px-2 text-xs text-text/80 transition-all duration-200 peer-placeholder-shown:top-1/2 peer-placeholder-shown:text-sm peer-focus:text-xs peer-focus:peer-placeholder-shown:top-0 xs:text-sm md:text-sm md:peer-placeholder-shown:text-base md:peer-focus:text-sm lg:start-5">
                        {{ __('*******')  }}
                    </span>
                </label>
                <p class="h-5 text-sm text-warning">
                    @error('passwordConfirmation') {{ $message }} @enderror
                </p>
            </div>

            <button type="button" wire:click="register" wire:loading.attr="disabled" wire:target="register" class="btn-primary py-3">
                {{ __('Register') }}
                <div wire:loading class="i-lucide-loader-circle animate-spin"></div>
            </button>
            <!-- rules -->
            <p class="mt-5 text-center text-sm text-text/80">
                {{ __('By entering the store, you accept all') }}
                <a href="{{ route('rules') }}" class="text-primary duration-200 hover:text-primary/80">{{ __('rules') }}.</a>
            </p>
        </div>
    </div>
</div>
