

<div>
    <div class="container">
        <!-- Breadcrumb -->
        <x-blesser.ui.breadcrumb :items="[
            ['url' => route('home'), 'label' => getSiteName()],
            ['url' => '#', 'label' => $product->category->name],
            ['url' => '#', 'label' => $product->title],
        ]" />

        <!-- Detail -->
        <div class="mb-16 grid grid-cols-12 gap-4">
            <div class="col-span-12 flex-grow rounded-lg bg-muted px-4 py-6 shadow-md lg:col-span-9">
                <div class="mb-6 grid grid-cols-12 gap-6">
                    <div class="col-span-12 space-y-4 lg:col-span-4 lg:min-w-fit">
                        <!-- Special Countdown -->
                        @if ($product->hasSpecialOffer())
                        <div class="flex flex-wrap items-center justify-between gap-x-2 font-medium md:justify-center 2xl:justify-between">
                            <div class="text-warning">
                                {{ __('Special offer') }}
                            </div>
                        </div>
                        @endif
                        <div>
                            <!-- Desktop Gallery -->
                            <div class="hidden space-y-4 lg:block">
                                <!-- Main image -->
                                <button type="button" data-modal-target="gallery-modal" data-modal-toggle="gallery-modal">
                                    <img src="{{ $product->brand_img }}" alt="{{ $product->title }}" loading="lazy" class="mx-auto h-full w-full cursor-pointer rounded-xl aspect-square object-cover">
                                </button>
                                <!-- Gallery -->
                                <div class="flex w-full flex-wrap items-center justify-center gap-2 square">
                                    @foreach ($gallery as $image )
                                    <button type="button" data-modal-target="gallery-modal" data-modal-toggle="gallery-modal" class="relative cursor-pointer overflow-hidden rounded-xl border">
                                        <img src="{{ $image->value }}" alt="{{ $product->title }}" loading="lazy" class="h-16 w-16">
                                    </button>
                                    @endforeach


                                    <button type="button" data-modal-target="gallery-modal" data-modal-toggle="gallery-modal" class="relative cursor-pointer overflow-hidden rounded-xl border">
                                        <img src="./assets/images/p1.png" alt="{{ $product->title }}" loading="lazy" class="h-16 w-16"><span class="absolute inset-0 flex items-center justify-center backdrop-blur-md">
                                            <div class="i-lucide-ellipsis size-6"></div>
                                        </span>
                                    </button>
                                </div>
                            </div>
                            <!-- Mobile Gallery -->
                            <div class="lg:hidden">
                                <div class="mb-4">
                                    <div class="swiper product-gallery-mobile-swiper swiper-initialized swiper-horizontal swiper-rtl">
                                        <div class="swiper-wrapper" id="swiper-wrapper-0103c411f8d900426" aria-live="polite" style="transition-duration: 0ms; transition-delay: 0ms;">
                                            @foreach ($gallery as $image )
                                            <div class="swiper-slide">
                                                <img src="{{ $image->value }}" alt="{{ $product->title }}" class="mx-auto h-[250px] rounded-lg object-cover">
                                            </div>
                                            @endforeach

                                        </div>
                                        <div class="swiper-pagination text-left swiper-pagination-bullets swiper-pagination-horizontal"></div>
                                        <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Mobile Actions ( Favorite, Compare, Share )-->
                        <div class="flex items-center justify-end gap-2 text-text/95 lg:hidden">
                            <button class="icon-btn h-10 w-10" title="Product add to Favorite">
                                <div class="i-lucide-heart size-6"></div>
                            </button>
                            <button class="icon-btn h-10 w-10">
                                <div class="i-lucide-align-horizontal-justify-center size-6"></div>
                            </button>

                            <button class="icon-btn h-10 w-10" data-state="closed" type="button" data-modal-target="share-modal" data-modal-toggle="share-modal">
                                <div class="i-lucide-share-2 size-6"></div>
                            </button>
                        </div>
                    </div>

                    <div class="col-span-12 flex min-h-full flex-col lg:col-span-8">
                        <div class="flex gap-4">
                            <div class="flex-grow">
                                <h1 class="mb-4 text-lg font-semibold">
                                    {{ $product->title }}
                                </h1>
                                <div class="mb-6 flex items-center gap-2">
                                    <h2 class="line-clamp-1 text-sm font-light text-text/60">
                                        {{ $product->category->name }}
                                    </h2>
                                    <span class="h-px flex-grow bg-secondary"></span>
                                </div>
                                <div class="mb-4 flex items-center gap-4 border-b pb-6 text-sm font-light">
                                    <div class="text-text/95">
                                        {{ __('code') }} : {{ $product->code }}
                                    </div>
                                    <span class="h-4 w-px rounded-full bg-secondary"></span>
                                    <div class="cursor-pointer text-primary">
                                        {{ __('comments') }}: {{ $product->comments->count() }}
                                    </div>
                                </div>
                            </div>

                            <!-- Desktop Actions ( Favorite, Compare, Share )-->
                            <div class="hidden flex-col items-center gap-2 text-text/95 lg:flex">
                                <div>
                                    @auth
                                    <livewire:blesser.like :product="$product" />
                                    @endauth
                                    @guest
                                    <div>
                                        <button data-popover-target="popover-favorite" data-popover-placement="right" type="button" class="icon-btn h-10 w-10" title="Product add to Favorite">
                                            <div class="i-lucide-heart size-6 "></div>
                                        </button>

                                        <div data-popover="" id="popover-favorite" role="tooltip" class="invisible absolute z-10 inline-block rounded-lg border bg-background px-2 py-1 text-sm opacity-0 shadow-sm transition-opacity duration-300" data-popper-placement="right" data-popper-reference-hidden="" data-popper-escaped="" style="position: absolute; inset: 0px auto auto 0px; margin: 0px; transform: translate(397px, 262px);">
                                            <div class="px-3 py-2">
                                                <p>
                                                    {{ __('add to favorite') }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>

                                    @endguest
                                </div>
                                @if (false)
                                <div>
                                    <button data-popover-target="popover-compare" data-popover-placement="right" type="button" class="icon-btn h-10 w-10" title="Product add to Favorite">
                                        <div class="i-lucide-align-horizontal-justify-center size-6"></div>
                                    </button>

                                    <div data-popover="" id="popover-compare" role="tooltip" class="invisible absolute z-10 inline-block rounded-lg border bg-background px-2 py-1 text-sm opacity-0 shadow-sm transition-opacity duration-300" data-popper-placement="right" data-popper-reference-hidden="" data-popper-escaped="" style="position: absolute; inset: 0px auto auto 0px; margin: 0px; transform: translate(397px, 310px);">
                                        <div class="px-3 py-2">
                                            <p>
                                                {{ __('add to compare') }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                @endif
                                <div>
                                    <button data-popover-target="popover-share" data-popover-placement="right" type="button" data-modal-target="share-modal" data-modal-toggle="share-modal" class="icon-btn h-10 w-10" title="Product add to Favorite">
                                        <div class="i-lucide-share-2 size-6"></div>
                                    </button>

                                    <div data-popover="" id="popover-share" role="tooltip" class="invisible absolute z-10 inline-block rounded-lg border bg-background px-2 py-1 text-sm opacity-0 shadow-sm transition-opacity duration-300" data-popper-placement="right" data-popper-reference-hidden="" style="position: absolute; inset: 0px auto auto 0px; margin: 0px; transform: translate(397px, 358px);">
                                        <div class="px-3 py-2">
                                            <p>
                                                {{ __('share') }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="flex flex-grow flex-col">
                            <!-- attribute selection -->
                            <div class="mb-8 space-y-4">
                                <div>
                                    @foreach ($productVariants as $variantAttribute )
                                    @php
                                    $inputs = collect($variantAttribute['items'])->map(function ($item) {
                                    return ['value' => $item['id'], 'label' => $item['value'], 'name' => $item['group']];
                                    });
                                    @endphp
                                    <div class="mb-3" wire:key="attribute-{{ $variantAttribute['id'] }}">
                                        <x-syndron.ui.form.input-radio-inline-row
                                            name="selectedVariants[{{$variantAttribute['name']}}][value]"
                                            :inputs="$inputs"
                                            wireName="selectedVariants.{{$variantAttribute['id']}}"
                                            :wire="true" />
                                    </div>
                                    @endforeach
                                </div>
                            </div>

                            <!-- Properties -->
                            <div>
                                <p class="mb-6 font-medium">
                                    {{ __('product specs') }}
                                </p>
                                <div class="grid gap-4 md:grid-cols-2 lg:grid-cols-3">
                                    @if (isset($product->attribute) && $product->attribute->isNotEmpty())
                                    @foreach ($product->attribute->shuffle()->take(3) as $attribute)
                                    <div class="space-y-1 rounded-lg bg-background px-4 py-2">
                                        <div class="line-clamp-1 text-xs text-text/60">
                                            {{ $attribute->label }}
                                        </div>
                                        <div class="line-clamp-1 text-sm text-text/95">
                                            {{ $attribute->value }}
                                        </div>
                                    </div>
                                    @endforeach
                                    @endif

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="hidden gap-2 md:grid md:grid-cols-2 xl:grid-cols-4">
                    <div class="flex w-full items-center gap-2 rounded-lg border px-2 py-4 text-sm text-text/60">
                        <div class="i-lucide-timer-reset size-6"></div>
                        {{ __('Seven days return guarantee') }}
                    </div>
                    <div class="flex w-full items-center gap-2 rounded-lg border px-2 py-4 text-sm text-text/60">
                        <div class="i-lucide-badge-check size-6"></div>
                        {{ __('Authenticity guarantee') }}
                    </div>
                    <div class="flex w-full items-center gap-2 rounded-lg border px-2 py-4 text-sm text-text/60">
                        <div class="i-lucide-headset size-6"></div>
                        {{ __('Seven days a week support') }}
                    </div>
                    <div class="flex w-full items-center gap-2 rounded-lg border px-2 py-4 text-sm text-text/60">
                        <div class="i-lucide-earth size-6"></div>
                        {{ __('Shipping across Iran') }}
                    </div>
                </div>
            </div>

            <!-- Desktop Add to Cart -->
            <div class="sticky top-36 col-span-3 hidden h-fit rounded-lg bg-muted px-4 py-6 shadow-md lg:block">
                @if ($outOfStock)
                <div class="flex justify-center items-center">
                    <span class="text-sm text-red-500">{{ __('This product is currently unavailable.') }}</span>
                </div>
                @else
                <div class="mb-6 flex justify-between">
                    <div>
                        <div class="flex flex-col gap-1">
                            @if ( $product->off_rate != 0 && $product->off_rate != null)
                            <div class="w-9 rounded-full bg-warning text-center text-sm text-white">
                                %{{ $product->off_rate }}
                            </div>
                            @endif

                            @if ($discountAmount != 0 )
                            <del class="text-sm text-text/60 xl:text-base">
                                {{ number_format($price + $discountAmount) }}
                            </del>
                            @endif

                        </div>
                    </div>
                    <div class="flex items-center gap-x-1">
                        <span class="font-bold xl:text-xl">
                            {{ $price == 0 ? 'برای خرید تماس بگیرید' : number_format($price ) }}
                        </span>
                        <span class="text-xs text-text/60">
                            {{ getCurrency() }}
                        </span>
                    </div>
                </div>
                <div>
                    <div>
                        <div>
                            @if ($price != 0)
                            <button wire:click="addToCart" class="btn-primary w-full py-2.5 cursor-pointer" aria-label="Add to Cart">
                                {{ __('add to cart') }}
                            </button>
                            @endif
                        </div>
                    </div>
                </div>
                @endif

            </div>

            <!-- Mobile Add to Cart -->
            <div data-onscrollclass="translate-y-1/2" class="fixed inset-x-0 bottom-0 z-20 rounded-t-xl bg-muted px-4 pb-20 pt-4 transition-all duration-300 lg:hidden translate-y-1/2">
                <div>
                    @if ($outOfStock)
                    <div class="flex justify-center items-center">
                        <span class="text-sm text-red-500">{{ __('This product is currently unavailable.') }}</span>
                    </div>
                    @else
                    @if ($price != 0)
                    <button wire:click="addToCart" class="btn-primary w-full py-2 cursor-pointer" aria-label="Add to Cart">
                        {{ __('add to cart') }} |
                        {{ $price == 0 ? 'برای خرید تماس بگیرید' : number_format($price ) }}
                        <span class="text-xs"> {{ getCurrency() }} </span>
                    </button>
                    @endif
                    @endif

                </div>
            </div>
        </div>

        <div class="mb-16">
            @if ($outOfStock == false)
            @forelse ($sellers as $seller)
            <div class="mb-4 block md:flex md:items-center md:justify-between rounded-lg bg-muted px-4 py-6 shadow-md  @if($seller->id == $selectedSeller) border-1 !border-primary @endif ">
                <div class="flex items-center gap-4">
                    <div class="flex h-16 w-16 items-center justify-center rounded-full bg-background">
                        <img data-scope="shop-profile" onerror="window.app.handleBrokenImage(this)" src="{{ asset("uploads/$seller->logo ") }}" alt="{{ $seller->name }}" class="h-10 w-10 rounded-full object-cover">
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-text/95">
                            {{ $seller->name }}
                        </h3>
                        <p class="text-xs text-text/60">
                            {{ $seller->description }}
                        </p>
                    </div>
                </div>

                <div class="flex flex-col md:flex-row items-center justify-end gap-5 ">
                    @php
                    $tempVariantForSeller = $inventoryVariants->groupBy('product_inventory_id')->get($inventory[$seller->id]->id, collect())->keyBy('combination_key')->get($combinationKey);
                    @endphp
                    <div>
                        {{ __('Inventory') }}:
                        {{ $tempVariantForSeller?->warehouseInventory?->qty_on_hand }}
                    </div>
                    <div>
                        @if ($combinationKey)
                        {{ number_format($tempVariantForSeller?->price_override) }}
                        @endif
                        <span class="text-xs text-text/60">
                            {{ getCurrency() }}
                        </span>
                    </div>
                    <button wire:click="selectSeller({{ $seller->id }})" class="btn-primary py-2.5 px-4 cursor-pointer" aria-label=" {{ __('select seller') }}">
                        {{ __('select seller') }}
                    </button>
                </div>
            </div>
            @empty

            @endforelse
            @endif
        </div>

        <div wire:ignore>
            <x-blesser.element.product-slider title="{{ __('similar products') }}" link="#" :category="$product->category_id" />
        </div>

        <!-- Information -->

        <div class="rounded-lg bg-muted px-4 py-6 shadow-md">
            <!-- Tabs -->
            <ul class="mb-6 flex justify-between gap-x-2 border-b text-center text-sm font-medium xs:justify-start xs:gap-x-4 xs:text-base">
                <li>
                    <div data-scroll-to="description" class="inline-block cursor-pointer rounded-t-lg border-b-2 border-transparent px-2 pb-2 duration-200 hover:text-primary">
                        {{ __('description') }}
                    </div>
                </li>
                <li>
                    <div data-scroll-to="specs" class="inline-block cursor-pointer rounded-t-lg border-b-2 border-transparent px-2 pb-2 duration-200 hover:text-primary">
                        {{ __('specs') }}
                    </div>
                </li>
                <li>
                    <div data-scroll-to="comment" class="inline-block cursor-pointer rounded-t-lg border-b-2 border-transparent px-2 pb-2 duration-200 hover:text-primary">
                        {{ __('comments') }}
                    </div>
                </li>
            </ul>
            <div class="divide-y divide-border">
                <!-- description -->

                <div class="py-6">
                    <div id="description" class="-translate-y-36"></div>
                    <div class="relative mb-16 w-fit text-2xl font-medium">
                        {{ __('description') }}
                        <span class="absolute right-0 top-10 h-[3px] w-full rounded-full bg-primary"></span>
                    </div>
                    <div data-show-more="">
                        <div data-show-max="450" class="mb-4 max-w-full overflow-hidden" style="max-height: 450px;">
                            <article class="whitespace-pre-line text-justify prose !max-w-full dark:prose-invert [&amp;_a]:text-primary [&amp;_a]:no-underline [&amp;_img]:mx-auto [&amp;_img]:rounded-xl [&amp;_ul]:list-inside">
                                {!! $product->content !!}
                            </article>
                        </div>
                        <div class="relative flex justify-center">
                            <button data-show-more-button="" type="button" data-drawer-target="description-drawer" data-drawer-show="description-drawer" data-drawer-placement="bottom" class="text-primary duration-300 hover:text-primary/80">
                                {{ __('show more') }}
                            </button>
                        </div>
                    </div>
                </div>
                <!-- Specs -->
                <div class="py-6">
                    <div id="specs" class="-translate-y-60"></div>
                    <div class="relative mb-16 w-fit text-2xl font-medium">
                        {{ __('specs') }}
                        <span class="absolute right-0 top-10 h-[3px] w-full rounded-full bg-primary"></span>
                    </div>

                    <div data-show-more="">
                        <div data-show-max="450" class="prose mb-4 max-w-full overflow-hidden dark:prose-invert" style="max-height: 450px;">
                            <ul class="w-full space-y-6 text-sm">
                                @forelse ($product->attribute as $attribute )
                                <li class="grid grid-cols-3 gap-x-2 lg:grid-cols-5">
                                    <div class="col-span-1 text-text/60">
                                        {{ $attribute->label }}
                                    </div>
                                    <div class="col-span-2 border-b pb-4 text-text/95 lg:col-span-4">
                                        <ul class="space-y-4">
                                            <li>
                                                {{ $attribute->value }}
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                @empty
                                @endforelse
                            </ul>
                        </div>
                        <div class="relative flex justify-center">
                            <button data-show-more-button="" type="button" data-drawer-target="specs-drawer" data-drawer-show="specs-drawer" data-drawer-placement="bottom" class="text-primary duration-300 hover:text-primary/80">
                                {{ __('show more') }}
                            </button>
                        </div>
                    </div>
                </div>
                <!-- Comments -->
                <x-blesser.element.comment :product="$product" />
            </div>
        </div>
    </div>


    <!-- Modals -->
    <!-- Share Modal -->
    <x-blesser.ui.modal id="share-modal">
        <x-slot name="header">
            <div class="flex items-center justify-between">
                <h3 class="md:text-lg">
                    {{ __('shear with your friend') }}
                </h3>

                <button class="text-text/60 duration-300 hover:text-text/95" data-modal-hide="share-modal" type="button">
                    <div class="i-lucide-x size-6"></div>
                    <span class="sr-only">Close menu</span>
                </button>
            </div>
        </x-slot>

        <div class="flex items-center gap-4">
            <x-blesser.share-button />
            <button class="text-primary" data-copy-clipboard="{{ route('product.details' , $product->slug) }}">
                <div class="i-lucide-copy size-6"></div>
                <div class="i-lucide-check hidden size-6"></div>
            </button>
            <div class="w-full">
                <div class="line-clamp-1 w-full select-none rounded-lg border px-4 py-3">
                    <input value="{{ route('product.details' , $product->slug) }}" class="w-full bg-transparent text-left outline-none" readonly="" type="text" />
                </div>
            </div>
        </div>

        <x-slot name="footer">
            <div class="flex justify-end">
                <button data-modal-hide="share-modal" type="button" class="btn-warning w-full rounded-lg px-4 py-2 md:w-auto">
                    <span>
                        {{ __('close') }}
                    </span>
                </button>

            </div>
        </x-slot>
    </x-blesser.ui.modal>

    <!-- Gallery Modal -->

    <x-blesser.ui.modal id="gallery-modal" width="max-w-5xl">
        <x-slot name="header">
            <div class="flex items-center justify-between">
                <h3 class="md:text-lg">
                    {{ $product->title }}
                </h3>

                <button class="text-text/60 duration-300 hover:text-text/95" data-modal-hide="gallery-modal" type="button">
                    <div class="i-lucide-x size-6"></div>

                    <span class="sr-only">Close menu</span>
                </button>
            </div>
        </x-slot>

        <div class="flex flex-col gap-4">
            <div>
                <div class="swiper product-gallery-swiper">
                    <div class="swiper-wrapper">
                        @foreach ($gallery as $image )
                        <div class="swiper-slide">
                            <img src="{{ $image->value }}" alt="{{ $product->title }}" class="mx-auto min-h-[500px] min-w-[500px]" loading="lazy" />
                        </div>
                        @endforeach
                    </div>
                    <div class="swiper-pagination"></div>
                    <div class="swiper-button-next main-slider-nav-button"></div>
                    <div class="swiper-button-prev main-slider-nav-button"></div>
                </div>
            </div>
        </div>


    </x-blesser.ui.modal>

    <!-- Drawers -->

    <!-- Description Drawer -->
    <x-blesser.ui.drawer id="description-drawer">
        <div class="grow overflow-y-auto px-4">
            <article class="container prose !max-w-xl dark:prose-invert [&_a]:text-primary [&_a]:no-underline [&_img]:mx-auto [&_img]:rounded-xl [&_ul]:list-inside">
                {!! $product->content !!}
            </article>
        </div>
    </x-blesser.ui.drawer>

    <!-- Specs Drawer -->
    <x-blesser.ui.drawer id="specs-drawer">
        <div class="grow overflow-y-auto pb-20">
            <ul class="container w-full space-y-6 text-sm">
                @forelse ($product->attribute as $attribute )
                <li class="grid grid-cols-3 gap-x-2 lg:grid-cols-5">
                    <div class="col-span-1 text-text/60">
                        {{ $attribute->label }}
                    </div>
                    <div class="col-span-2 border-b pb-4 text-text/95 lg:col-span-4">
                        <ul class="space-y-4">
                            <li>
                                {{ $attribute->value }}
                            </li>
                        </ul>
                    </div>
                </li>
                @empty
                @endforelse
            </ul>
        </div>
    </x-blesser.ui.drawer>

    <!-- comments List Drawer -->
    <x-blesser.ui.drawer id="comment-list-drawer">
        <div class="grow overflow-y-auto pb-10">
            <ul class="space-y-6 px-4">
                <li>
                    <div class="flex h-64 flex-col rounded-lg border">
                        <div aria-controls="comment-detail-drawer" data-drawer-show="comment-detail-drawer" data-drawer-placement="bottom" data-drawer-target="comment-detail-drawer" type="button" class="flex-grow cursor-pointer px-4 pt-6">
                            <div class="mb-4 flex items-center gap-2">
                                <div class="truncate">کاربر {{ getSiteName() }}</div>
                                <div class="rounded-full bg-success/10 px-4 py-1 text-sm text-success">خریدار</div>
                            </div>
                            <div class="mb-4 flex items-center gap-x-2 text-warning">
                                <div class="i-lucide-thumbs-down size-5"></div>
                                پیشنهاد نمیکنم
                            </div>
                            <div class="space-y-2">
                                <h5 class="truncate text-sm leading-relaxed">عنوان تست تست</h5>
                                <p class="line-clamp-2 text-sm leading-relaxed text-text/80">متن تست متن تست متن تست متن تست متن تست</p>
                            </div>
                        </div>

                        <div class="flex items-center justify-between px-4 pb-6">
                            <div class="flex items-center gap-6">
                                <button class="relative flex items-center gap-2 text-success duration-300 hover:text-success/80 disabled:text-success/50 disabled:hover:text-success/40">
                                    <span class="i-lucide-thumbs-up size-6"></span>

                                    <span class="absolute -right-2 top-6 text-sm"> 32 </span>
                                </button>
                                <button class="relative flex items-center gap-2 text-warning duration-300 hover:text-warning/80 disabled:text-warning/50 disabled:hover:text-warning/40">
                                    <span class="i-lucide-thumbs-down size-6"></span>
                                    <span class="absolute -right-2 top-6 text-sm"> 76 </span>
                                </button>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="text-xs text-text/60">شنبه 4 خرداد</div>
                            </div>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="flex h-64 flex-col rounded-lg border">
                        <div aria-controls="comment-detail-drawer" data-drawer-show="comment-detail-drawer" data-drawer-placement="bottom" data-drawer-target="comment-detail-drawer" type="button" class="flex-grow cursor-pointer px-4 pt-6">
                            <div class="mb-4 flex items-center gap-2">
                                <div class="truncate">کاربر {{ getSiteName() }}</div>
                                <div class="rounded-full bg-success/10 px-4 py-1 text-sm text-success">خریدار</div>
                            </div>
                            <div class="mb-4 flex items-center gap-x-2 text-warning">
                                <div class="i-lucide-thumbs-down size-5"></div>
                                پیشنهاد نمیکنم
                            </div>
                            <div class="space-y-2">
                                <h5 class="truncate text-sm leading-relaxed">عنوان تست تست</h5>
                                <p class="line-clamp-2 text-sm leading-relaxed text-text/80">متن تست متن تست متن تست متن تست متن تست</p>
                            </div>
                        </div>

                        <div class="flex items-center justify-between px-4 pb-6">
                            <div class="flex items-center gap-6">
                                <button class="relative flex items-center gap-2 text-success duration-300 hover:text-success/80 disabled:text-success/50 disabled:hover:text-success/40">
                                    <span class="i-lucide-thumbs-up size-6"></span>

                                    <span class="absolute -right-2 top-6 text-sm"> 32 </span>
                                </button>
                                <button class="relative flex items-center gap-2 text-warning duration-300 hover:text-warning/80 disabled:text-warning/50 disabled:hover:text-warning/40">
                                    <span class="i-lucide-thumbs-down size-6"></span>
                                    <span class="absolute -right-2 top-6 text-sm"> 76 </span>
                                </button>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="text-xs text-text/60">شنبه 4 خرداد</div>
                            </div>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="flex h-64 flex-col rounded-lg border">
                        <div aria-controls="comment-detail-drawer" data-drawer-show="comment-detail-drawer" data-drawer-placement="bottom" data-drawer-target="comment-detail-drawer" type="button" class="flex-grow cursor-pointer px-4 pt-6">
                            <div class="mb-4 flex items-center gap-2">
                                <div class="truncate">کاربر {{ getSiteName() }}</div>
                                <div class="rounded-full bg-success/10 px-4 py-1 text-sm text-success">خریدار</div>
                            </div>
                            <div class="mb-4 flex items-center gap-x-2 text-warning">
                                <div class="i-lucide-thumbs-down size-5"></div>
                                پیشنهاد نمیکنم
                            </div>
                            <div class="space-y-2">
                                <h5 class="truncate text-sm leading-relaxed">عنوان تست تست</h5>
                                <p class="line-clamp-2 text-sm leading-relaxed text-text/80">متن تست متن تست متن تست متن تست متن تست</p>
                            </div>
                        </div>

                        <div class="flex items-center justify-between px-4 pb-6">
                            <div class="flex items-center gap-6">
                                <button class="relative flex items-center gap-2 text-success duration-300 hover:text-success/80 disabled:text-success/50 disabled:hover:text-success/40">
                                    <span class="i-lucide-thumbs-up size-6"></span>

                                    <span class="absolute -right-2 top-6 text-sm"> 32 </span>
                                </button>
                                <button class="relative flex items-center gap-2 text-warning duration-300 hover:text-warning/80 disabled:text-warning/50 disabled:hover:text-warning/40">
                                    <span class="i-lucide-thumbs-down size-6"></span>
                                    <span class="absolute -right-2 top-6 text-sm"> 76 </span>
                                </button>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="text-xs text-text/60">شنبه 4 خرداد</div>
                            </div>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="flex h-64 flex-col rounded-lg border">
                        <div aria-controls="comment-detail-drawer" data-drawer-show="comment-detail-drawer" data-drawer-placement="bottom" data-drawer-target="comment-detail-drawer" type="button" class="flex-grow cursor-pointer px-4 pt-6">
                            <div class="mb-4 flex items-center gap-2">
                                <div class="truncate">کاربر {{ getSiteName() }}</div>
                                <div class="rounded-full bg-success/10 px-4 py-1 text-sm text-success">خریدار</div>
                            </div>
                            <div class="mb-4 flex items-center gap-x-2 text-warning">
                                <div class="i-lucide-thumbs-down size-5"></div>
                                پیشنهاد نمیکنم
                            </div>
                            <div class="space-y-2">
                                <h5 class="truncate text-sm leading-relaxed">عنوان تست تست</h5>
                                <p class="line-clamp-2 text-sm leading-relaxed text-text/80">متن تست متن تست متن تست متن تست متن تست</p>
                            </div>
                        </div>

                        <div class="flex items-center justify-between px-4 pb-6">
                            <div class="flex items-center gap-6">
                                <button class="relative flex items-center gap-2 text-success duration-300 hover:text-success/80 disabled:text-success/50 disabled:hover:text-success/40">
                                    <span class="i-lucide-thumbs-up size-6"></span>

                                    <span class="absolute -right-2 top-6 text-sm"> 32 </span>
                                </button>
                                <button class="relative flex items-center gap-2 text-warning duration-300 hover:text-warning/80 disabled:text-warning/50 disabled:hover:text-warning/40">
                                    <span class="i-lucide-thumbs-down size-6"></span>
                                    <span class="absolute -right-2 top-6 text-sm"> 76 </span>
                                </button>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="text-xs text-text/60">شنبه 4 خرداد</div>
                            </div>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </x-blesser.ui.drawer>

    <!-- Comment Detail Drawer -->
    <x-blesser.ui.drawer id="comment-detail-drawer">
        <div class="grow overflow-y-auto pb-10">
            <!-- Detail -->
            <div class="mb-6 px-4 py-2">
                <div class="mb-2 flex items-center gap-2">
                    <div>کاربر {{ getSiteName() }}</div>
                    <div class="rounded-full bg-success/10 px-4 py-1 text-sm text-success">خریدار</div>
                    <div class="text-sm text-text/60">شنبه 4 خرداد</div>
                </div>

                <div class="mb-4 leading-relaxed xl:text-lg">عنوان تست</div>
                <div class="mb-6 flex items-center gap-x-4 border-b pb-6">
                    <div class="flex items-center gap-x-2 text-warning">
                        <div class="i-lucide-thumbs-down size-6"></div>
                        پیشنهاد نمیکنم
                    </div>
                </div>
                <div class="mb-6 border-b pb-6">
                    <p class="text-sm text-text/80">صبشصبش صبشبصش</p>
                </div>
                <div class="flex items-center justify-end gap-4">
                    <div class="text-xs text-text/60 xs:text-sm">آیا این دیدگاه برایتان مفید بود؟</div>
                    <button class="flex items-center gap-2 text-success duration-300 hover:text-success/80 disabled:text-success/50 disabled:hover:text-success/40">
                        <span class="text-sm"> 32 </span>

                        <span class="i-lucide-thumbs-up size-6"></span>
                    </button>
                    <button class="flex items-center gap-2 text-warning duration-300 hover:text-warning/80 disabled:text-warning/50 disabled:hover:text-warning/40">
                        <span class="text-sm"> 76 </span>
                        <span class="i-lucide-thumbs-down size-6"></span>
                    </button>
                </div>
            </div>
            <!-- Submit Reply-->
            <form class="mb-6 grid grid-cols-2 gap-4 px-4">
                <div class="lg:text-lg">ثبت پاسخ</div>
                <div class="col-span-2">
                    <label for="reply" class="sr-only"> متن پاسخ </label>
                    <textarea rows="3" placeholder="متن پاسخ" type="text" id="reply" class="mb-2 w-full rounded-lg border bg-transparent px-4 py-2.5 outline-none duration-300 placeholder:duration-300 focus:border-primary focus:placeholder:-translate-x-2"></textarea>
                    <!--                                            <div class="text-warning h-5 text-sm">-->
                    <!--                                                                                    این فیلد الزامی می باشد-->
                    <!--                                            </div>-->
                </div>

                <div class="col-span-2 flex justify-end">
                    <button class="btn-primary px-4 py-2">ثبت پاسخ</button>
                </div>
            </form>
            <!-- Replies -->
            <div class="px-4">
                <p class="mb-8 text-lg font-medium">پاسخ ها ( 4 )</p>
                <ul class="space-y-4">
                    <li>
                        <div>
                            <div class="mb-8 flex items-center gap-2">
                                <div>کاربر {{ getSiteName() }}</div>
                                <div class="rounded-full bg-primary/10 px-4 py-1 text-sm text-primary">فروشنده</div>
                                <div class="text-sm text-text/60">شنبه 4 خرداد</div>
                            </div>

                            <div class="border-b pb-6">
                                <p class="text-sm text-text/80">صبشصبش صبشبصش</p>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div>
                            <div class="mb-8 flex items-center gap-2">
                                <div>کاربر {{ getSiteName() }}</div>
                                <div class="rounded-full bg-primary/10 px-4 py-1 text-sm text-primary">فروشنده</div>
                                <div class="text-sm text-text/60">شنبه 4 خرداد</div>
                            </div>

                            <div class="border-b pb-6">
                                <p class="text-sm text-text/80">صبشصبش صبشبصش</p>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div>
                            <div class="mb-8 flex items-center gap-2">
                                <div>کاربر {{ getSiteName() }}</div>
                                <div class="rounded-full bg-primary/10 px-4 py-1 text-sm text-primary">فروشنده</div>
                                <div class="text-sm text-text/60">شنبه 4 خرداد</div>
                            </div>

                            <div class="border-b pb-6">
                                <p class="text-sm text-text/80">صبشصبش صبشبصش</p>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div>
                            <div class="mb-8 flex items-center gap-2">
                                <div>کاربر {{ getSiteName() }}</div>
                                <div class="rounded-full bg-primary/10 px-4 py-1 text-sm text-primary">فروشنده</div>
                                <div class="text-sm text-text/60">شنبه 4 خرداد</div>
                            </div>

                            <div class="border-b pb-6">
                                <p class="text-sm text-text/80">صبشصبش صبشبصش</p>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </x-blesser.ui.drawer>
</div>
