<div>
    <ul class="mb-4 space-y-4 px-5">
        @forelse ($addresses as $address)
        <x-blesser.element.address-item :wire="true" :selection="$selection" :address="$address" :selected="$address->id == $selectedAddress" />
        @empty
        <p class="text-center">
            {{ __('You don\'t have any saved addresses yet.') }}
        </p>
        @endforelse
    </ul>
    <div class="px-5">
        <button @click="if ($wire.$parent.action != 'create') { $dispatch('update-action', { action: 'create' }) } "
            type="button"
            class="not-prose relative flex w-full cursor-pointer rounded-md border text-sm transition-all duration-150 hover:bg-background hover:text-success disabled:cursor-not-allowed disabled:blur">
            <span class="w-full">
                <span class="relative flex h-20 w-full select-none items-center justify-center overflow-hidden rounded opacity-75">
                    <svg class="absolute inset-0 h-full w-full stroke-border" fill="none">
                        <defs>
                            <pattern id="pattern-5c1e4f0e-62d5-498b-8ff0-cf77bb448c8e" x="0" y="0" width="10"
                                height="10" patternUnits="userSpaceOnUse">
                                <path d="M-3 13 15-5M-5 5l18-18M-1 21 17 3"></path>
                            </pattern>
                        </defs>
                        <rect stroke="none" fill="url(#pattern-5c1e4f0e-62d5-498b-8ff0-cf77bb448c8e)" width="100%"
                            height="100%"></rect>
                    </svg>
                    <span class="i-material-symbols-add-location-alt-outline-rounded z-10 size-8 text-primary">
                    </span>
                </span>
            </span>
        </button>
    </div>
</div>
