<!doctype html>
<html lang="en" dir="rtl">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--favicon-->
    <link rel="icon" href="/assets/themes/syndron/images/favicon-32x32.png" type="image/png" />
    <!--plugins-->
    <link href="/assets/themes/syndron/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <!-- loader-->
    <link href="/assets/themes/syndron/css/pace.min.css" rel="stylesheet" />
    <script src="/assets/themes/syndron/js/pace.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="/assets/themes/syndron/css/bootstrap.min.css" rel="stylesheet">
    <link href="/assets/themes/syndron/css/bootstrap-extended.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="/assets/themes/syndron/css/app.css" rel="stylesheet">
    <link href="/assets/themes/syndron/css/icons.css" rel="stylesheet">
    <title>{{ getSiteName() }}</title>
</head>

<body class="">
    <!--wrapper-->
    <div class="wrapper">
        <div class="section-authentication-cover">
            <div class="">
                <div class="row g-0">

                    <div class="col-12 col-xl-7 col-xxl-8 auth-cover-left align-items-center justify-content-center d-none d-xl-flex">

                        <div class="card shadow-none bg-transparent shadow-none rounded-0 mb-0">
                            <div class="card-body">
                                <img src="/assets/themes/syndron/images/login-images/login-cover.svg" class="img-fluid auth-img-cover-login" width="650" alt="" />
                            </div>
                        </div>

                    </div>

                    <div class="col-12 col-xl-5 col-xxl-4 auth-cover-right align-items-center justify-content-center">
                        <div class="card rounded-0 m-3 shadow-none bg-transparent mb-0">
                            <div class="card-body p-sm-5">
                                <div class="">
                                    <div class="mb-3 text-center">
                                        <img src="{{ getSiteLogo() }}" width="60" alt="">
                                    </div>
                                    <div class="text-center mb-4">
                                        <h5 class="">{{ getSiteName() }}</h5>
                                        <p class="mb-0">{{ __('Please log in to your account') }}</p>
                                    </div>
                                    <div class="form-body">
                                        @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul>
                                                @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                        @endif
                                        @session('status')
                                        <div class="alert alert-danger">
                                            {{ session('status') }}
                                        </div>
                                        @endsession
                                        <form class="row g-3" action="{{ route('login') }}" method="post">
                                            @csrf
                                            <div class="col-12">
                                                <label for="inputEmailAddress" class="form-label">{{ __('Email') }}</label>
                                                <input type="text" name="identifier" class="form-control" id="inputEmailAddress" placeholder="jhon@example.com">
                                            </div>
                                            <div class="col-12">
                                                <label for="inputChoosePassword" class="form-label">{{ __('Password') }}</label>
                                                <div class="input-group" id="show_hide_password">
                                                    <input type="password" name="password" class="form-control border-end-0" id="inputChoosePassword" placeholder="{{ __('Enter Password') }}"> <a href="javascript:;" class="input-group-text bg-transparent"><i class="bx bx-hide"></i></a>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="flexSwitchCheckChecked">
                                                    <label class="form-check-label" for="flexSwitchCheckChecked">{{ __('Remember Me') }}</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 text-end"> <a href="auth-cover-forgot-password.html">{{ __('Forgot Password ?') }}</a>
                                            </div>
                                            <div class="col-12">
                                                <div class="d-grid">
                                                    <button type="submit" class="btn btn-primary">{{ __('Sign in') }}</button>
                                                </div>
                                            </div>
                                            <div class="col-12">
                                                <div class="text-center">
                                                    <p class="mb-0">{{ __('Don\'t have an account yet?') }} <a href="auth-cover-signup.html">{{ __('Sign up here') }}</a>
                                                    </p>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="login-separater text-center mb-5 d-none"> <span>{{ __('OR SIGN IN WITH') }}</span>
                                        <hr>
                                    </div>
                                    <div class="list-inline contacts-social text-center d-none">
                                        <a href="javascript:;" class="list-inline-item bg-facebook text-white border-0 rounded-3"><i class="bx bxl-facebook"></i></a>
                                        <a href="javascript:;" class="list-inline-item bg-twitter text-white border-0 rounded-3"><i class="bx bxl-twitter"></i></a>
                                        <a href="javascript:;" class="list-inline-item bg-google text-white border-0 rounded-3"><i class="bx bxl-google"></i></a>
                                        <a href="javascript:;" class="list-inline-item bg-linkedin text-white border-0 rounded-3"><i class="bx bxl-linkedin"></i></a>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!--end row-->
            </div>
        </div>
    </div>
    <!--end wrapper-->
    <!-- Bootstrap JS -->
    <script src="/assets/themes/syndron/js/bootstrap.bundle.min.js"></script>
    <!--plugins-->
    <script src="/assets/themes/syndron/js/jquery.min.js"></script>
    <script src="/assets/themes/syndron/plugins/simplebar/js/simplebar.min.js"></script>
    <script src="/assets/themes/syndron/plugins/metismenu/js/metisMenu.min.js"></script>
    <script src="/assets/themes/syndron/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
    <!--Password show & hide js -->
    <script>
        $(document).ready(function() {
            $("#show_hide_password a").on('click', function(event) {
                event.preventDefault();
                if ($('#show_hide_password input').attr("type") == "text") {
                    $('#show_hide_password input').attr('type', 'password');
                    $('#show_hide_password i').addClass("bx-hide");
                    $('#show_hide_password i').removeClass("bx-show");
                } else if ($('#show_hide_password input').attr("type") == "password") {
                    $('#show_hide_password input').attr('type', 'text');
                    $('#show_hide_password i').removeClass("bx-hide");
                    $('#show_hide_password i').addClass("bx-show");
                }
            });
        });
    </script>
    <!--app JS-->
    <script src="/assets/themes/syndron/js/app.js"></script>
</body>

</html>
