@extends('layouts.syndron.app')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4>{{ __('Coupons') }}</h4>
        <a class="btn btn-success" href="{{ route('admin.coupons.create') }}">
            <i class="fas fa-plus"></i> {{ __('Create New Coupon') }}
        </a>
    </div>

    <div class="card-body">
        @if(session('success'))
        <div class="alert alert-success" role="alert">
            {{ session('success') }}
        </div>
        @endif

        <x-syndron.ui.table :columns="[__('Code'), __('Type'), __('Amount'), __('Expire Date'), __('Usage Limit'), __('Actions')]">
            @forelse ($coupons as $coupon)
            <tr>
                <td>{{ $coupon->code }}</td>
                <td>{{ __($coupon->type  )}}</td>
                <td>
                    @if($coupon->type === 'Percentage Discount')
                    {{ $coupon->amount }}%
                    @else
                    {{-- Format as currency if you have a helper, otherwise just the number --}}
                    {{ number_format($coupon->amount, 2) }}
                    @endif
                </td>
                <td dir="ltr">{{ $coupon->expire_date ? verta($coupon->expire_date)->format('Y-m-d H:i') : __('N/A') }}</td>
                <td>{{ $coupon->usage_limit ?? __('Unlimited') }}</td>
                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenuButton{{ $coupon->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton{{ $coupon->id }}">
                            @can('coupon.edit')
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.coupons.edit', $coupon->id) }}">
                                    <i class="fas fa-edit"></i> {{ __('Edit') }}
                                </a>
                            </li>
                            @endcan
                            @can('coupon.delete')
                            <li>
                                <form action="{{ route('admin.coupons.destroy', $coupon->id) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this coupon?') ?>');" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">
                                        <i class="fas fa-trash"></i> {{ __('Delete') }}
                                    </button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="6" class="text-center">{{ __('No coupons found.') }}</td>
            </tr>
            @endforelse
        </x-syndron.ui.table>

        @if ($coupons->hasPages())
        <div class="mt-3">
            {{ $coupons->links() }}
        </div>
        @endif
    </div>
</div>
@endsection
