@extends('layouts.syndron.app')

@section('content')

<section class="">
    <h3>{{ __('Orders Overview') }}</h3>
    <div class="row row-cols-1 row-cols-md-3 row-cols-lg-5">
        <div class="p-2">
            <x-syndron.elements.widgets.static-card :amount="$newOrdersCount" :title="__('new')" trend="info" />
        </div>
        <div class="p-2">
            <x-syndron.elements.widgets.static-card :amount="$todayOrdersCount" :title="__('Today')" trend="success" />
        </div>
        <div class="p-2">
            <x-syndron.elements.widgets.static-card :amount="$thisMonthOrdersCount" :title="__('This Month')" trend="secondary" />
        </div>
        <div class="p-2">
            <x-syndron.elements.widgets.static-card :amount="$totalOrdersCount" :title="__('total')" trend="primary" />
        </div>
        <div class="p-2">
            <x-syndron.elements.widgets.static-card :amount="$abandonedOrdersCount" :title="__('abandoned')" trend="warning" />
        </div>
    </div>
</section>
<section class="">
    <h3>{{ __('sales Overview') }}</h3>
    <div class="row">
        <div class="col-sm-12 col-md-7 col-lg-9">
            <div class="card radius-10 w-100">
                <div class="card-body">
                    <p class="font-weight-bold mb-1 text-secondary">Sales</p>
                    <div class="d-flex align-items-center">
                        <div>
                            <!-- <h4 class="mb-0">43,540</h4> -->
                        </div>
                        <div class="">
                            <!-- <p class="mb-0 align-self-center font-weight-bold text-success ms-2">4.4 <i class="bx bxs-up-arrow-alt mr-2"></i></p> -->
                        </div>
                    </div>
                    <div id="chart21"></div>
                </div>
            </div>
        </div>
        <div class="d-flex flex-column  gap-2 col-sm-12 col-md-5 col-lg-3">
            <x-syndron.elements.widgets.static-card :amount="number_format($todaySales)" :title="__('Today')" trend="info" />
            <x-syndron.elements.widgets.static-card :amount="number_format($monthSales)" :title="__('This Month')" trend="success" />
            <x-syndron.elements.widgets.static-card :amount="number_format($totalSales)" :title="__('Total')" trend="secondary" />
        </div>
    </div>
</section>


<section class="row row-cols-1 row-cols-md-2 ">
    <div>
        <div class="card radius-10 w-100">
            <div class="card-header">
                <div class="d-flex align-items-center">
                    <div>
                        <h5 class="mb-0">{{ __('New Customers') }}</h5>
                    </div>

                </div>
            </div>
            <div class="customers-list p-3 mb-3">
                <ul class="list-group list-group-flush">
                    @foreach($newCustomers as $customer)
                    <x-syndron.elements.user-list-item :user="$customer" />
                    @endforeach
                </ul>
            </div>
        </div>
    </div>
    <div>
        <div class="card radius-10 w-100">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div>
                        <h5 class="mb-0">{{ __('Product count group by category') }}</h5>
                    </div>

                </div>
                <div class="mt-5" id="chart15"></div>
            </div>
            <ul class="list-group list-group-flush">

            </ul>
        </div>
    </div>

</section>

<section class="row row-cols-1 row-cols-md-2 ">
    <div>
        <div class="card radius-10 w-100">
            <div class="card-header">
                <div class="d-flex align-items-center">
                    <div>
                        <h5 class="mb-0">{{ __('New Shops') }}</h5>
                    </div>

                </div>
            </div>
            <div class="customers-list p-3 mb-3">
                <ul class="list-group list-group-flush">
                    @foreach($newShops as $shop)
                    <x-syndron.elements.shop-list-item :shop="$shop" />
                    @endforeach
                </ul>
            </div>
        </div>
    </div>
    <div>
        <div class="card radius-10 w-100">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div>
                        <h5 class="mb-0">{{ __('Shop Count') }}</h5>
                    </div>

                </div>
                <div class="mt-5" id="shopsChart"></div>
            </div>
        </div>
    </div>

</section>
@endsection

@section('script')
<script>
    new PerfectScrollbar(".customers-list")

    e = {
        series: [{
            name: "Sales",
            data: <?php echo json_encode($monthlySales); ?>
        }],
        chart: {
            foreColor: "#6c757d",
            type: "bar",
            height: 390,
            toolbar: {
                show: !1
            },
            zoom: {
                enabled: !1
            },
            dropShadow: {
                enabled: !1,
                top: 3,
                left: 10,
                blur: 3,
                opacity: .1,
                color: "#0d6efd"
            },
            sparkline: {
                enabled: !1
            }
        },
        plotOptions: {
            radialBar: {
                hollow: {
                    size: "70%"
                }
            },
            bar: {
                horizontal: !1,
                columnWidth: "35%",
                endingShape: "rounded"
            }
        },
        markers: {
            size: 0,
            colors: ["#0d6efd"],
            strokeColors: "#fff",
            strokeWidth: 2,
            hover: {
                size: 7
            }
        },
        dataLabels: {
            enabled: !1
        },
        stroke: {
            show: !0,
            width: 3,
            curve: "smooth"
        },
        colors: ["#0d6efd"],
        xaxis: {
            categories: <?php echo json_encode($months); ?>
        },
        grid: {
            show: true,
            borderColor: 'rgba(0, 0, 0, 0.15)',
            strokeDashArray: 4,
        },
        fill: {
            opacity: 1
        }
    };
    new ApexCharts(document.querySelector("#chart21"), e).render();


    e = {
        series: <?php echo json_encode(array_values($categories->toArray())); ?>,
        chart: {
            height: 240,
            type: "donut"
        },
        legend: {
            position: "bottom",
            show: !1
        },
        plotOptions: {
            pie: {
                donut: {
                    size: "80%",
                    labels: {
                        show: true,
                        name: {
                            fontSize: '14px',
                            fontWeight: 'bold',
                            color: '#333',
                            offsetY: 5
                        },
                        value: {
                            fontSize: '14px',
                            fontWeight: 'bold',
                            color: '#333'
                        },
                        total: {
                            show: true,
                            label: '<?php echo __('Total') ?>',
                            fontSize: '14px',
                            fontWeight: 'bold',
                            color: '#333',
                            formatter: function(w) {
                                return w.globals.seriesTotals.reduce((a, b) => a + b, 0);
                            }
                        }
                    }
                }
            }
        },
        dataLabels: {
            enabled: !1
        },
        labels: <?php echo json_encode(array_keys($categories->toArray())); ?>,
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    height: 200
                },
                legend: {
                    position: "bottom"
                }
            }
        }]
    };
    new ApexCharts(document.querySelector("#chart15"), e).render();

    e = {
        series: [<?php echo $approvedShopsCount ?>, <?php echo $notApprovedShopsCount ?>],
        chart: {
            height: 240,
            type: "donut"
        },
        legend: {
            position: "bottom",
            show: 1
        },
        plotOptions: {
            pie: {
                donut: {
                    size: "80%",
                    labels: {
                        show: true,
                        name: {
                            fontSize: '14px',
                            fontWeight: 'bold',
                            color: '#333',
                            offsetY: 5
                        },
                        value: {
                            fontSize: '14px',
                            fontWeight: 'bold',
                            color: '#333',
                        },
                        total: {
                            show: true,
                            label: '<?php echo __('Total') ?>',
                            fontSize: '14px',
                            fontWeight: 'bold',
                            color: '#333',
                            formatter: function(w) {
                                return w.globals.seriesTotals.reduce((a, b) => a + b, 0);
                            }
                        }
                    }
                }
            }
        },
        dataLabels: {
            enabled: !1
        },
        labels: ['<?php echo __('Approved') ?>', '<?php echo __('Not Approved') ?>'],
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    height: 200
                },
                legend: {
                    position: "bottom"
                }
            }
        }],
    };
    new ApexCharts(document.querySelector("#shopsChart"), e).render();
</script>
@endsection
