@extends('layouts.admin')

@section('content')
<div class="container">
    <h1>{{ __('Add Delivery') }}</h1>
    <form action="{{ route('admin.deliveries.store') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label for="provider_id" class="form-label">{{ __('Provider ID') }}</label>
            <input type="number" name="provider_id" id="provider_id" class="form-control" value="{{ old('provider_id') }}" required>
        </div>
        <div class="mb-3">
            <label for="slot_id" class="form-label">{{ __('Slot ID') }}</label>
            <input type="number" name="slot_id" id="slot_id" class="form-control" value="{{ old('slot_id') }}" required>
        </div>
        <div class="mb-3">
            <label for="status" class="form-label">{{ __('Status') }}</label>
            <input type="text" name="status" id="status" class="form-control" value="{{ old('status') }}" required>
        </div>
        <div class="mb-3">
            <label for="tracking_code" class="form-label">{{ __('Tracking Code') }}</label>
            <input type="text" name="tracking_code" id="tracking_code" class="form-control" value="{{ old('tracking_code') }}">
        </div>
        <button type="submit" class="btn btn-success">{{ __('Save') }}</button>
        <a href="{{ route('admin.deliveries.index') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
    </form>
</div>
@endsection
