@extends('layouts.admin')
@section('content')
<div class="container">
    <h1>{{ __('Edit Delivery Item') }}</h1>
    <form action="{{ route('admin.delivery-items.update', $delivery_item) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label for="delivery_id" class="form-label">Delivery ID</label>
            <input type="number" name="delivery_id" id="delivery_id" class="form-control" value="{{ old('delivery_id', $delivery_item->delivery_id) }}" required>
        </div>
        <div class="mb-3">
            <label for="order_item_id" class="form-label">Order Item ID</label>
            <input type="number" name="order_item_id" id="order_item_id" class="form-control" value="{{ old('order_item_id', $delivery_item->order_item_id) }}" required>
        </div>
        <button type="submit" class="btn btn-success">{{ __('Update') }}</button>
        <a href="{{ route('admin.delivery-items.index') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
    </form>
</div>
@endsection
