@extends('layouts.syndron.app')

@section('content')


<div class="card">
    <div class="card-body">
        <x-syndron.ui.table :columns="['ID','Date','Delivery Time ID','User ID','Actions']">
            @foreach($deliveryTimeReservations as $reservation)
            <tr>
                <td>{{ $reservation->id }}</td>
                <td>{{ $reservation->date }}</td>
                <td>{{ $reservation->delivery_time_id }}</td>
                <td>{{ $reservation->user_id }}</td>
                <td>
                    @can('delivery.time-reservation.delete')
                    <form action="{{ route('admin.delivery.time-reservations.destroy', $reservation) }}" method="POST" style="display:inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('<?php echo __('Are you sure?'); ?>')">{{ __('Delete') }}</button>
                    </form>
                    @endcan
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
