@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>
                {{ __('Delivery Provider') }}
            </h4>
        </div>
        <div>
            <a class="btn btn-success" href="{{ route('admin.delivery.times.create') }}">
                {{ __('Create a new Delivery Provider') }}
            </a>
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['day' , 'from' , 'until','capacity','action']">
            @foreach ($deliveryTimes as $time )
            <tr>
                <td>{{ $time->day  }}</td>
                <td>{{ $time->from  }}</td>
                <td>{{ $time->until  }}</td>
                <td>{{ $time->capacity  }}</td>

                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                            @can('delivery.time.edit')
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.delivery.times.edit' , $time->id) }}">
                                    {{ __('Edit') }}
                                </a>
                            </li>

                            @endcan

                            @can('delivery.time.exception.view')
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.delivery.time.exceptions.index' , $time->id) }}">
                                    {{ __('Time Exceptions') }}
                                </a>
                            </li>
                            @endcan

                            @can('delivery.time.delete')
                            <li>
                                <form action="{{ route('admin.delivery.times.destroy' , $time->id) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this times?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
