@extends('layouts.syndron.app')

@section('title', __('Orders'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">

            <div class="card">
                <dic class="card-header d-flex justify-content-between">
                    <div>
                        {{ __('Order List') }}
                    </div>
                    <div>
                        <a class="btn btn-success" href="route('admin.orders.create')">{{ __('Create Order') }}</a>
                    </div>
                </dic>
                <div class="card-body">
                    @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    @if(session('error'))
                    <div class="alert alert-danger">{{ session('error') }}</div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('Tracking Code') }}</th>
                                    <th>{{ __('Customer Name') }}</th>
                                    <th>{{ __('Email') }}</th>
                                    <th>{{ __('Amount') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Order Date') }}</th>
                                    <th>{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($orders as $order)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        <a href="{{ route('admin.orders.show', $order) }}">{{ $order->tracking_code }}</a>
                                    </td>
                                    <td>{{ $order->name }}</td>
                                    <td>{{ $order->email }}</td>
                                    <td>{{ number_format($order->amount_with_discount ?? $order->amount) }}</td>
                                    <td><span class="badge bg-primary">{{ __(ucfirst($order->status)) }}</span></td>
                                    <td>{{ verta($order->created_at)->format('d F, Y | H:i') }}</td>
                                    <td>
                                        <a href="{{ route('admin.orders.show', $order) }}" class="btn btn-sm btn-info">{{ __('View') }}</a>

                                        @if (false)
                                        <a href="{{ route('admin.orders.edit', $order) }}" class="btn btn-sm btn-primary">{{ __('Edit') }}</a>
                                        @endif
                                        <form action="{{ route('admin.orders.destroy', $order) }}" method="POST" class="d-inline" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this order?')?>');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">{{ __('Delete') }}</button>
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">{{ __('No orders found.') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        {{ $orders->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
